"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_COMMONS_NODE_API = exports.FORECAST_NODE_API = exports.FORECAST_BASE_NODE_API_PATH = exports.DAILY_INSIGHTS_ENABLED = exports.BASE_NODE_API_PATH = exports.ALERTING_NODE_API = exports.AD_NODE_API = void 0;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const BASE_NODE_API_PATH = exports.BASE_NODE_API_PATH = '/api/anomaly_detectors';
const AD_NODE_API = exports.AD_NODE_API = Object.freeze({
  _SEARCH: `${BASE_NODE_API_PATH}/_search`,
  _INDICES: `${BASE_NODE_API_PATH}/_indices`,
  _ALIASES: `${BASE_NODE_API_PATH}/_aliases`,
  _MAPPINGS: `${BASE_NODE_API_PATH}/_mappings`,
  DETECTOR: `${BASE_NODE_API_PATH}/detectors`,
  CREATE_INDEX: `${BASE_NODE_API_PATH}/create_index`,
  BULK: `${BASE_NODE_API_PATH}/bulk`,
  DELETE_INDEX: `${BASE_NODE_API_PATH}/delete_index`,
  CREATE_SAMPLE_DATA: `${BASE_NODE_API_PATH}/create_sample_data`,
  GET_CLUSTERS_INFO: `${BASE_NODE_API_PATH}/_remote/info`,
  GET_INDICES_AND_ALIASES: `${BASE_NODE_API_PATH}/_indices_and_aliases`,
  INSIGHTS_START: `${BASE_NODE_API_PATH}/insights/_start`,
  INSIGHTS_STOP: `${BASE_NODE_API_PATH}/insights/_stop`,
  INSIGHTS_STATUS: `${BASE_NODE_API_PATH}/insights/_status`,
  INSIGHTS_RESULTS: `${BASE_NODE_API_PATH}/insights/_results`
});
const ALERTING_NODE_API = exports.ALERTING_NODE_API = Object.freeze({
  _SEARCH: `${BASE_NODE_API_PATH}/monitors/_search`,
  ALERTS: `${BASE_NODE_API_PATH}/monitors/alerts`,
  MONITORS: `${BASE_NODE_API_PATH}/monitors`
});
const ML_COMMONS_NODE_API = exports.ML_COMMONS_NODE_API = Object.freeze({
  AGENT_EXECUTE: `/api/ml/agents`
});
const FORECAST_BASE_NODE_API_PATH = exports.FORECAST_BASE_NODE_API_PATH = '/api/forecasting';
const FORECAST_NODE_API = exports.FORECAST_NODE_API = Object.freeze({
  _SEARCH: `${FORECAST_BASE_NODE_API_PATH}/_search`,
  _INDICES: `${FORECAST_BASE_NODE_API_PATH}/_indices`,
  _ALIASES: `${FORECAST_BASE_NODE_API_PATH}/_aliases`,
  _MAPPINGS: `${FORECAST_BASE_NODE_API_PATH}/_mappings`,
  FORECASTER: `${FORECAST_BASE_NODE_API_PATH}/forecasters`,
  CREATE_INDEX: `${FORECAST_BASE_NODE_API_PATH}/create_index`,
  BULK: `${FORECAST_BASE_NODE_API_PATH}/bulk`,
  DELETE_INDEX: `${FORECAST_BASE_NODE_API_PATH}/delete_index`,
  CREATE_SAMPLE_DATA: `${FORECAST_BASE_NODE_API_PATH}/create_sample_data`,
  GET_CLUSTERS_INFO: `${FORECAST_BASE_NODE_API_PATH}/_remote/info`,
  GET_INDICES_AND_ALIASES: `${FORECAST_BASE_NODE_API_PATH}/_indices_and_aliases`
});

// Feature Flags
const DAILY_INSIGHTS_ENABLED = exports.DAILY_INSIGHTS_ENABLED = 'anomalyDetection:dailyInsightsEnabled';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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