"use strict";

require("@testing-library/jest-dom/extend-expect");
var _react = require("@testing-library/react");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

(0, _react.configure)({
  testIdAttribute: 'data-test-subj'
});
jest.mock('@elastic/eui/lib/components/form/form_row/make_id', () => () => 'random_id');
jest.mock('@elastic/eui/lib/services/accessibility/html_id_generator', () => ({
  htmlIdGenerator: () => {
    return () => 'random_html_id';
  }
}));

// address issue: https://github.com/opensearch-project/anomaly-detection-dashboards-plugin/issues/832
// jest.mock('@osd/monaco', () => ({}));
// Provide a minimal monaco mock for tests
jest.mock('@osd/monaco', () => ({
  monaco: {
    languages: {
      CompletionItemKind: {
        Function: 1,
        // matches Monaco API:contentReference[oaicite:4]{index=4}
        Operator: 11,
        Module: 8,
        Keyword: 17,
        Variable: 4,
        Field: 3,
        Class: 5,
        Value: 13
      }
    }
  }
}));

//for mocking window.scroll(0,0)
const noop = () => {};
Object.defineProperty(window, 'scroll', {
  value: noop,
  writable: true
});

// for Plotly
//@ts-ignore
window.URL.createObjectURL = function () {};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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