"use strict";

var _events = require("events");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

var __extends = void 0 && (void 0).__extends || function () {
  var extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return function (d, b) {
    extendStatics(d, b);
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
}();
module.exports = {};
Object.defineProperty(module.exports, '__esModule', {
  value: true
});
var Util = /** @class */function () {
  function Util() {}
  Util.clone = function ($target, config) {
    var recurse = true; // set true so childList we'll always check the first level
    return function copy($target) {
      var elestruct = {
        /** @type {Node} */
        node: $target,
        charData: null,
        attr: null,
        kids: null
      };
      // Store current character data of target text or comment node if the config requests
      // those properties to be observed.
      if (config.charData && ($target.nodeType === 3 || $target.nodeType === 8)) {
        elestruct.charData = $target.nodeValue;
      } else {
        // Add attr only if subtree is specified or top level and avoid if
        // attributes is a document object (#13).
        if (config.attr && recurse && $target.nodeType === 1) {
          /**
           * clone live attribute list to an object structure {name: val}
           * @type {Object.<string, string>}
           */
          elestruct.attr = Util.reduce($target.attributes, function (memo, attr) {
            if (!config.afilter || config.afilter[attr.name]) {
              memo[attr.name] = attr.value;
            }
            return memo;
          }, {});
        }
        // whether we should iterate the children of $target node
        if (recurse && (config.kids || config.charData || config.attr && config.descendents)) {
          /** @type {Array.<!Object>} : Array of custom clone */
          elestruct.kids = Util.map($target.childNodes, copy);
        }
        recurse = config.descendents;
      }
      return elestruct;
    }($target);
  };
  /**
   * indexOf an element in a collection of custom nodes
   *
   * @param {NodeList} set
   * @param {!Object} $node : A custom cloned nodeg333
   * @param {number} idx : index to start the loop
   * @return {number}
   */
  Util.indexOfCustomNode = function (set, $node, idx) {
    var JSCompiler_renameProperty = function (a) {
      return a;
    };
    return this.indexOf(set, $node, idx, JSCompiler_renameProperty('node'));
  };
  /**
   * Attempt to uniquely id an element for hashing. We could optimize this for legacy browsers but it hopefully wont be called enough to be a concern
   *
   * @param {Node} $ele
   * @return {(string|number)}
   */
  Util.getElementId = function ($ele) {
    try {
      return $ele.id || ($ele[this.expando] = $ele[this.expando] || this.counter++);
    } catch (e) {
      // ie <8 will throw if you set an unknown property on a text node
      try {
        return $ele.nodeValue; // naive
      } catch (shitie) {
        // when text node is removed: https://gist.github.com/megawac/8355978 :(
        return this.counter++;
      }
    }
  };
  /**
   * **map** Apply a mapping function to each item of a set
   * @param {Array|NodeList} set
   * @param {Function} iterator
   */
  Util.map = function (set, iterator) {
    var results = [];
    for (var index = 0; index < set.length; index++) {
      results[index] = iterator(set[index], index, set);
    }
    return results;
  };
  /**
   * **Reduce** builds up a single result from a list of values
   * @param {Array|NodeList|NamedNodeMap} set
   * @param {Function} iterator
   * @param {*} [memo] Initial value of the memo.
   */
  Util.reduce = function (set, iterator, memo) {
    for (var index = 0; index < set.length; index++) {
      memo = iterator(memo, set[index], index, set);
    }
    return memo;
  };
  /**
   * **indexOf** find index of item in collection.
   * @param {Array|NodeList} set
   * @param {Object} item
   * @param {number} idx
   * @param {string} [prop] Property on set item to compare to item
   */
  Util.indexOf = function (set, item, idx, prop) {
    for (; /*idx = ~~idx*/idx < set.length; idx++) {
      // start idx is always given as this is internal
      if ((prop ? set[idx][prop] : set[idx]) === item) return idx;
    }
    return -1;
  };
  /**
   * @param {Object} obj
   * @param {(string|number)} prop
   * @return {boolean}
   */
  Util.has = function (obj, prop) {
    return obj[prop] !== undefined; // will be nicely inlined by gcc
  };

  Util.counter = 1;
  Util.expando = 'mo_id';
  return Util;
}();
module.exports.Util = Util;
var MutationObserver = /** @class */function () {
  function MutationObserver(listener) {
    var _this = this;
    this._watched = [];
    this._listener = null;
    this._period = 30;
    this._timeout = null;
    this._disposed = false;
    this._notifyListener = null;
    this._watched = [];
    this._listener = listener;
    this._period = 30;
    this._notifyListener = function () {
      _this.scheduleMutationCheck(_this);
    };
  }
  MutationObserver.prototype.observe = function ($target, config) {
    var settings = {
      attr: !!(config.attributes || config.attributeFilter || config.attributeOldValue),
      // some browsers enforce that subtree must be set with childList, attributes or characterData.
      // We don't care as spec doesn't specify this rule.
      kids: !!config.childList,
      descendents: !!config.subtree,
      charData: !!(config.characterData || config.characterDataOldValue),
      afilter: null
    };
    MutationNotifier.getInstance().on('changed', this._notifyListener);
    var watched = this._watched;
    // remove already observed target element from pool
    for (var i = 0; i < watched.length; i++) {
      if (watched[i].tar === $target) watched.splice(i, 1);
    }
    if (config.attributeFilter) {
      /**
       * converts to a {key: true} dict for faster lookup
       * @type {Object.<String,Boolean>}
       */
      settings.afilter = Util.reduce(config.attributeFilter, function (a, b) {
        a[b] = true;
        return a;
      }, {});
    }
    watched.push({
      tar: $target,
      fn: this.createMutationSearcher($target, settings)
    });
  };
  MutationObserver.prototype.takeRecords = function () {
    var mutations = [];
    var watched = this._watched;
    for (var i = 0; i < watched.length; i++) {
      watched[i].fn(mutations);
    }
    return mutations;
  };
  MutationObserver.prototype.disconnect = function () {
    this._watched = []; // clear the stuff being observed
    MutationNotifier.getInstance().removeListener('changed', this._notifyListener);
    this._disposed = true;
    clearTimeout(this._timeout); // ready for garbage collection
    this._timeout = null;
  };
  MutationObserver.prototype.createMutationSearcher = function ($target, config) {
    var _this = this;
    /** type {Elestuct} */
    var $oldstate = Util.clone($target, config); // create the cloned datastructure
    /**
     * consumes array of mutations we can push to
     *
     * @param {Array.<MutationRecord>} mutations
     */
    return function (mutations) {
      var olen = mutations.length;
      var dirty;
      if (config.charData && $target.nodeType === 3 && $target.nodeValue !== $oldstate.charData) {
        mutations.push(new MutationRecord({
          type: 'characterData',
          target: $target,
          oldValue: $oldstate.charData
        }));
      }
      // Alright we check base level changes in attributes... easy
      if (config.attr && $oldstate.attr) {
        _this.findAttributeMutations(mutations, $target, $oldstate.attr, config.afilter);
      }
      // check childlist or subtree for mutations
      if (config.kids || config.descendents) {
        dirty = _this.searchSubtree(mutations, $target, $oldstate, config);
      }
      // reclone data structure if theres changes
      if (dirty || mutations.length !== olen) {
        /** type {Elestuct} */
        $oldstate = Util.clone($target, config);
      }
    };
  };
  MutationObserver.prototype.scheduleMutationCheck = function (observer) {
    var _this = this;
    // Only schedule if there isn't already a timer.
    if (!observer._timeout) {
      observer._timeout = setTimeout(function () {
        return _this.mutationChecker(observer);
      }, this._period);
    }
  };
  MutationObserver.prototype.mutationChecker = function (observer) {
    // allow scheduling a new timer.
    observer._timeout = null;
    var mutations = observer.takeRecords();
    if (mutations.length) {
      // fire away
      // calling the listener with context is not spec but currently consistent with FF and WebKit
      observer._listener(mutations, observer);
    }
  };
  MutationObserver.prototype.searchSubtree = function (mutations, $target, $oldstate, config) {
    var _this = this;
    // Track if the tree is dirty and has to be recomputed (#14).
    var dirty;
    /*
     * Helper to identify node rearrangment and stuff...
     * There is no gaurentee that the same node will be identified for both added and removed nodes
     * if the positions have been shuffled.
     * conflicts array will be emptied by end of operation
     */
    var _resolveConflicts = function (conflicts, node, $kids, $oldkids, numAddedNodes) {
      // the distance between the first conflicting node and the last
      var distance = conflicts.length - 1;
      // prevents same conflict being resolved twice consider when two nodes switch places.
      // only one should be given a mutation event (note -~ is used as a math.ceil shorthand)
      var counter = -~((distance - numAddedNodes) / 2);
      var $cur;
      var oldstruct;
      var conflict;
      while (conflict = conflicts.pop()) {
        $cur = $kids[conflict.i];
        oldstruct = $oldkids[conflict.j];
        // attempt to determine if there was node rearrangement... won't gaurentee all matches
        // also handles case where added/removed nodes cause nodes to be identified as conflicts
        if (config.kids && counter && Math.abs(conflict.i - conflict.j) >= distance) {
          mutations.push(new MutationRecord({
            type: 'childList',
            target: node,
            addedNodes: [$cur],
            removedNodes: [$cur],
            // haha don't rely on this please
            nextSibling: $cur.nextSibling,
            previousSibling: $cur.previousSibling
          }));
          counter--; // found conflict
        }
        // Alright we found the resorted nodes now check for other types of mutations
        if (config.attr && oldstruct.attr) _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
        if (config.charData && $cur.nodeType === 3 && $cur.nodeValue !== oldstruct.charData) {
          mutations.push(new MutationRecord({
            type: 'characterData',
            target: $cur,
            oldValue: oldstruct.charData
          }));
        }
        // now look @ subtree
        if (config.descendents) _findMutations($cur, oldstruct);
      }
    };
    /**
     * Main worker. Finds and adds mutations if there are any
     * @param {Node} node
     * @param {!Object} old : A cloned data structure using internal clone
     */
    var _findMutations = function (node, old) {
      var $kids = node.childNodes;
      var $oldkids = old.kids;
      var klen = $kids.length;
      // $oldkids will be undefined for text and comment nodes
      var olen = $oldkids ? $oldkids.length : 0;
      // if (!olen && !klen) return; // both empty; clearly no changes
      // we delay the intialization of these for marginal performance in the expected case (actually quite signficant on large subtrees when these would be otherwise unused)
      // map of checked element of ids to prevent registering the same conflict twice
      var map;
      // array of potential conflicts (ie nodes that may have been re arranged)
      var conflicts;
      var id; // element id from getElementId helper
      var idx; // index of a moved or inserted element
      var oldstruct;
      // current and old nodes
      var $cur;
      var $old;
      // track the number of added nodes so we can resolve conflicts more accurately
      var numAddedNodes = 0;
      // iterate over both old and current child nodes at the same time
      var i = 0;
      var j = 0;
      // while there is still anything left in $kids or $oldkids (same as i < $kids.length || j < $oldkids.length;)
      while (i < klen || j < olen) {
        // current and old nodes at the indexs
        $cur = $kids[i];
        oldstruct = $oldkids[j];
        $old = oldstruct && oldstruct.node;
        if ($cur === $old) {
          // expected case - optimized for this case
          // check attributes as specified by config
          if (config.attr && oldstruct.attr) {
            /* oldstruct.attr instead of textnode check */
            _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
          }
          // check character data if node is a comment or textNode and it's being observed
          if (config.charData && oldstruct.charData !== undefined && $cur.nodeValue !== oldstruct.charData) {
            mutations.push(new MutationRecord({
              type: 'characterData',
              target: $cur
            }));
          }
          // resolve conflicts; it will be undefined if there are no conflicts - otherwise an array
          if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
          // recurse on next level of children. Avoids the recursive call when there are no children left to iterate
          if (config.descendents && ($cur.childNodes.length || oldstruct.kids && oldstruct.kids.length)) _findMutations($cur, oldstruct);
          i++;
          j++;
        } else {
          // (uncommon case) lookahead until they are the same again or the end of children
          dirty = true;
          if (!map) {
            // delayed initalization (big perf benefit)
            map = {};
            conflicts = [];
          }
          if ($cur) {
            // check id is in the location map otherwise do a indexOf search
            if (!map[id = Util.getElementId($cur)]) {
              // to prevent double checking
              // mark id as found
              map[id] = true;
              // custom indexOf using comparitor checking oldkids[i].node === $cur
              if ((idx = Util.indexOfCustomNode($oldkids, $cur, j)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: 'childList',
                    target: node,
                    addedNodes: [$cur],
                    nextSibling: $cur.nextSibling,
                    previousSibling: $cur.previousSibling
                  }));
                  numAddedNodes++;
                }
              } else {
                conflicts.push({
                  i: i,
                  j: idx
                });
              }
            }
            i++;
          }
          if ($old &&
          // special case: the changes may have been resolved: i and j appear congurent so we can continue using the expected case
          $old !== $kids[i]) {
            if (!map[id = Util.getElementId($old)]) {
              map[id] = true;
              if ((idx = Util.indexOf($kids, $old, i)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: 'childList',
                    target: old.node,
                    removedNodes: [$old],
                    nextSibling: $oldkids[j + 1],
                    previousSibling: $oldkids[j - 1]
                  }));
                  numAddedNodes--;
                }
              } else {
                conflicts.push({
                  i: idx,
                  j: j
                });
              }
            }
            j++;
          }
        } // end uncommon case
      } // end loop
      // resolve any remaining conflicts
      if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
    };
    _findMutations($target, $oldstate);
    return dirty;
  };
  MutationObserver.prototype.findAttributeMutations = function (mutations, $target, $oldstate, filter) {
    var checked = {};
    var attributes = $target.attributes;
    var attr;
    var name;
    var i = attributes.length;
    while (i--) {
      attr = attributes[i];
      name = attr.name;
      if (!filter || Util.has(filter, name)) {
        if (attr.value !== $oldstate[name]) {
          // The pushing is redundant but gzips very nicely
          mutations.push(new MutationRecord({
            type: 'attributes',
            target: $target,
            attributeName: name,
            oldValue: $oldstate[name],
            attributeNamespace: attr.namespaceURI // in ie<8 it incorrectly will return undefined
          }));
        }

        checked[name] = true;
      }
    }
    for (name in $oldstate) {
      if (!checked[name]) {
        mutations.push(new MutationRecord({
          target: $target,
          type: 'attributes',
          attributeName: name,
          oldValue: $oldstate[name]
        }));
      }
    }
  };
  return MutationObserver;
}();
module.exports.MutationObserver = MutationObserver;
var MutationRecord = /** @class */function () {
  function MutationRecord(data) {
    var settings = {
      type: null,
      target: null,
      addedNodes: [],
      removedNodes: [],
      previousSibling: null,
      nextSibling: null,
      attributeName: null,
      attributeNamespace: null,
      oldValue: null
    };
    for (var prop in data) {
      if (Util.has(settings, prop) && data[prop] !== undefined) settings[prop] = data[prop];
    }
    return settings;
  }
  return MutationRecord;
}();
module.exports.MutationRecord = MutationRecord;
var MutationNotifier = /** @class */function (_super) {
  __extends(MutationNotifier, _super);
  function MutationNotifier() {
    var _this = _super.call(this) || this;
    _this.setMaxListeners(100);
    return _this;
  }
  MutationNotifier.getInstance = function () {
    if (!MutationNotifier._instance) {
      MutationNotifier._instance = new MutationNotifier();
    }
    return MutationNotifier._instance;
  };
  MutationNotifier.prototype.destruct = function () {
    this.removeAllListeners('changed');
  };
  MutationNotifier.prototype.notifyChanged = function (node) {
    this.emit('changed', node);
  };
  MutationNotifier._instance = null;
  return MutationNotifier;
}(_events.EventEmitter);
module.exports.MutationNotifier = MutationNotifier;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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