"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * The transform configuration in Jest allows you to 
 * specify custom transformation logic for specific file types during testing. 
 */
module.exports = {
  /**
   * This function is responsible for transforming the file.
   * @returns the string module.exports = {};, which is an empty CommonJS module.
   */
  process() {
    return {
      code: `module.exports = {};`
    };
  },
  /**
   * The cache key helps Jest determine if a file needs to be retransformed or if it can use the cached transformation result. 
   * @returns a unique string that serves as a cache key for the transformation. 
   */
  getCacheKey() {
    return 'svgTransform';
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJtb2R1bGUiLCJleHBvcnRzIiwicHJvY2VzcyIsImNvZGUiLCJnZXRDYWNoZUtleSJdLCJzb3VyY2VzIjpbInRyYW5zZm9ybU1vY2sudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuLyoqXHJcbiAqIFRoZSB0cmFuc2Zvcm0gY29uZmlndXJhdGlvbiBpbiBKZXN0IGFsbG93cyB5b3UgdG8gXHJcbiAqIHNwZWNpZnkgY3VzdG9tIHRyYW5zZm9ybWF0aW9uIGxvZ2ljIGZvciBzcGVjaWZpYyBmaWxlIHR5cGVzIGR1cmluZyB0ZXN0aW5nLiBcclxuICovXHJcbm1vZHVsZS5leHBvcnRzID0ge1xyXG4gIC8qKlxyXG4gICAqIFRoaXMgZnVuY3Rpb24gaXMgcmVzcG9uc2libGUgZm9yIHRyYW5zZm9ybWluZyB0aGUgZmlsZS5cclxuICAgKiBAcmV0dXJucyB0aGUgc3RyaW5nIG1vZHVsZS5leHBvcnRzID0ge307LCB3aGljaCBpcyBhbiBlbXB0eSBDb21tb25KUyBtb2R1bGUuXHJcbiAgICovXHJcbiAgcHJvY2VzcygpIHtcclxuICAgIHJldHVybiB7XHJcbiAgICAgIGNvZGU6IGBtb2R1bGUuZXhwb3J0cyA9IHt9O2AsXHJcbiAgICB9O1xyXG4gIH0sXHJcbiAgLyoqXHJcbiAgICogVGhlIGNhY2hlIGtleSBoZWxwcyBKZXN0IGRldGVybWluZSBpZiBhIGZpbGUgbmVlZHMgdG8gYmUgcmV0cmFuc2Zvcm1lZCBvciBpZiBpdCBjYW4gdXNlIHRoZSBjYWNoZWQgdHJhbnNmb3JtYXRpb24gcmVzdWx0LiBcclxuICAgKiBAcmV0dXJucyBhIHVuaXF1ZSBzdHJpbmcgdGhhdCBzZXJ2ZXMgYXMgYSBjYWNoZSBrZXkgZm9yIHRoZSB0cmFuc2Zvcm1hdGlvbi4gXHJcbiAgICovXHJcbiAgZ2V0Q2FjaGVLZXkoKSB7XHJcbiAgICByZXR1cm4gJ3N2Z1RyYW5zZm9ybSc7XHJcbiAgfSxcclxufTsiXSwibWFwcGluZ3MiOiI7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQUEsTUFBTSxDQUFDQyxPQUFPLEdBQUc7RUFDZjtBQUNGO0FBQ0E7QUFDQTtFQUNFQyxPQUFPQSxDQUFBLEVBQUc7SUFDUixPQUFPO01BQ0xDLElBQUksRUFBRztJQUNULENBQUM7RUFDSCxDQUFDO0VBQ0Q7QUFDRjtBQUNBO0FBQ0E7RUFDRUMsV0FBV0EsQ0FBQSxFQUFHO0lBQ1osT0FBTyxjQUFjO0VBQ3ZCO0FBQ0YsQ0FBQyJ9