"use strict";

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.ts', '<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.ts',
    '^opensearch-dashboards/public$': '<rootDir>/../../src/core/public'
  },
  testEnvironment: 'jest-environment-jsdom',
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.js', '**/*.test.jsx', '**/*.test.ts', '**/*.test.tsx'],
  collectCoverageFrom: ['**/*.ts', '**/*.tsx', '**/*.js', '**/*.jsx', '!**/models/**', '!**/node_modules/**', '!**/index.js', '!<rootDir>/public/app.js', '!<rootDir>/index.js', '!<rootDir>/babel.config.js', '!<rootDir>/test/**', '!<rootDir>/server/**', '!<rootDir>/coverage/**', '!<rootDir>/scripts/**', '!<rootDir>/build/**', '!**/vendor/**'],
  clearMocks: true,
  modulePathIgnorePatterns: ['<rootDir>/offline-module-cache/'],
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  transformIgnorePatterns: ['<rootDir>/node_modules'],
  globalSetup: '<rootDir>/global-setup.js',
  /**
   * This configuration specifies different file extensions 
   * and the corresponding transformers to be used
   */
  transform: {
    '\\.[jt]sx?$': 'babel-jest',
    '^.+\\.svg$': '<rootDir>/test/mocks/transformMock.ts',
    '^.+\\.html$': '<rootDir>/test/mocks/transformMock.ts'
  },
  setupFiles: ["jest-canvas-mock"]
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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