"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatAnomalyNumber = exports.SHOW_DECIMAL_NUMBER_THRESHOLD = exports.NO_PERMISSIONS_KEY_WORD = exports.DOES_NOT_HAVE_PERMISSIONS_KEY_WORD = exports.CANT_FIND_KEY_WORD = void 0;
exports.getClientBasedOnDataSource = getClientBasedOnDataSource;
exports.getFloorPlotTime = void 0;
exports.mapKeysDeep = mapKeysDeep;
exports.toSnake = exports.toFixedNumberForForecast = exports.toFixedNumberForAnomaly = exports.toFixedNumber = exports.toCamel = exports.prettifyErrorMessage = void 0;
var _lodash = require("lodash");
var _constants = require("./constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const SHOW_DECIMAL_NUMBER_THRESHOLD = exports.SHOW_DECIMAL_NUMBER_THRESHOLD = 0.01;
function mapKeysDeep(obj, fn) {
  if (Array.isArray(obj)) {
    return (0, _lodash.map)(obj, innerObj => mapKeysDeep(innerObj, fn));
  } else {
    //@ts-ignore
    return (0, _lodash.isPlainObject)(obj) ? (0, _lodash.mapValues)((0, _lodash.mapKeys)(obj, fn), value => mapKeysDeep(value, fn)) : obj;
  }
}
const toSnake = (value, key) => (0, _lodash.snakeCase)(key);
exports.toSnake = toSnake;
const toCamel = (value, key) => (0, _lodash.camelCase)(key);
exports.toCamel = toCamel;
const getFloorPlotTime = plotTime => {
  return Math.floor(plotTime / _constants.MIN_IN_MILLI_SECS) * _constants.MIN_IN_MILLI_SECS;
};
exports.getFloorPlotTime = getFloorPlotTime;
const toFixedNumber = (num, digits, base) => {
  var pow = Math.pow(base || 10, digits || 2);
  return Math.round(num * pow) / pow;
};

// 1.If num>0.01, will keep two digits;
// 2.If num<0.01, will use scientific notation, for example 0.001234 will become 1.23e-3
exports.toFixedNumber = toFixedNumber;
const toFixedNumberForAnomaly = num => {
  return num >= SHOW_DECIMAL_NUMBER_THRESHOLD ? toFixedNumber(num, 2) : Number(num.toExponential(2));
};
exports.toFixedNumberForAnomaly = toFixedNumberForAnomaly;
const formatAnomalyNumber = num => {
  return num >= SHOW_DECIMAL_NUMBER_THRESHOLD ? num.toFixed(2) : num.toExponential(2);
};
exports.formatAnomalyNumber = formatAnomalyNumber;
const PERMISSIONS_ERROR_PATTERN = /no permissions for \[(.+)\] and User \[name=(.+), backend_roles/;
const NO_PERMISSIONS_KEY_WORD = exports.NO_PERMISSIONS_KEY_WORD = 'no permissions';
const DOES_NOT_HAVE_PERMISSIONS_KEY_WORD = exports.DOES_NOT_HAVE_PERMISSIONS_KEY_WORD = 'does not have permissions';
const CANT_FIND_KEY_WORD = exports.CANT_FIND_KEY_WORD = "Can't find";
const prettifyErrorMessage = rawErrorMessage => {
  if ((0, _lodash.isEmpty)(rawErrorMessage) || rawErrorMessage === 'undefined') {
    return 'Unknown error is returned.';
  }
  const match = rawErrorMessage.match(PERMISSIONS_ERROR_PATTERN);
  if ((0, _lodash.isEmpty)(match)) {
    return rawErrorMessage;
  } else {
    return `User ${match[2]} has no permissions to [${match[1]}].`;
  }
};
exports.prettifyErrorMessage = prettifyErrorMessage;
function getClientBasedOnDataSource(context, dataSourceEnabled, request, dataSourceId, client) {
  if (dataSourceEnabled && dataSourceId && dataSourceId.trim().length != 0) {
    // client for remote cluster
    return context.dataSource.opensearch.legacy.getClient(dataSourceId).callAPI;
  } else {
    // fall back to default local cluster
    return client.asScoped(request).callAsCurrentUser;
  }
}

// 1.If abs(num)>=0.01, will keep two digits;
// 2.If abs(num)<0.01, will use scientific notation, for example 0.001234 will become 1.23e-3
const toFixedNumberForForecast = num => {
  return Math.abs(num) >= SHOW_DECIMAL_NUMBER_THRESHOLD ? toFixedNumber(num, 2) : Number(num.toExponential(2));
};
exports.toFixedNumberForForecast = toFixedNumberForForecast;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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