"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEEK_IN_MILLI_SECS = exports.SUGGEST_ANOMALY_DETECTOR_CONFIG_ID = exports.STACK_TRACE_PATTERN = exports.SORT_DIRECTION = exports.SEC_IN_MILLI_SECS = exports.SAMPLE_TYPE = exports.REALTIME_TASK_TYPE_PREFIX = exports.REALTIME_TASK_TYPES = exports.OPENSEARCH_EXCEPTION_PREFIX = exports.MODEL_ID_FIELD = exports.MIN_IN_MILLI_SECS = exports.MAX_MONITORS = exports.MAX_FORECASTER = exports.MAX_DETECTORS = exports.MAX_ANOMALY_GRADE_FIELD = exports.MAX_ALERTS = exports.KEY_FIELD = exports.HOUR_IN_MILLI_SECS = exports.HISTORICAL_TASK_TYPE_PREFIX = exports.HISTORICAL_TASK_TYPES = exports.HEATMAP_CELL_ENTITY_DELIMITER = exports.HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = exports.FORECAST_RUN_ONCE_TASK_TYPES = exports.FORECAST_REALTIME_TASK_TYPES = exports.FORECAST_API_ROUTE_PREFIX = exports.FORECASTER_STATE_TO_DISPLAY = exports.FORECASTER_STATE_DISPLAY = exports.FORECASTER_STATE = exports.FORECASTER_DOC_FIELDS = exports.ENTITY_VALUE_PATH_FIELD = exports.ENTITY_NAME_PATH_FIELD = exports.ENTITY_LIST_FIELD = exports.ENTITY_LIST_DELIMITER = exports.ENTITY_FIELD = exports.DOC_COUNT_FIELD = exports.DETECTOR_STATE = exports.DETECTORS_QUERY_PARAMS = exports.DEFAULT_HEADERS = exports.DEFAULT_FORECAST_RESULT_INDEX_WILDCARD = exports.DAY_IN_MILLI_SECS = exports.CUSTOM_FORECAST_RESULT_INDEX_WILDCARD = exports.CUSTOM_FORECAST_RESULT_INDEX_PREFIX = exports.CUSTOM_FORECASTER_RESULT_INDEX_PREFIX = exports.CUSTOM_AD_RESULT_INDEX_PREFIX = exports.CLUSTER = exports.API = exports.ALERTING_API_ROUTE_PREFIX = exports.AD_DOC_FIELDS = exports.AD_API_ROUTE_PREFIX = void 0;
exports.isActiveState = isActiveState;
exports.isForecasterErrorState = void 0;
exports.isTestState = isTestState;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const AD_API_ROUTE_PREFIX = exports.AD_API_ROUTE_PREFIX = '/_plugins/_anomaly_detection';
const ALERTING_API_ROUTE_PREFIX = exports.ALERTING_API_ROUTE_PREFIX = '/_plugins/_alerting';
const FORECAST_API_ROUTE_PREFIX = exports.FORECAST_API_ROUTE_PREFIX = '/_plugins/_forecast';
// custom forecast result index starts with opensearch-forecast-result-
// while default forecast result index starts with opensearch-forecast-results
const DEFAULT_FORECAST_RESULT_INDEX_WILDCARD = exports.DEFAULT_FORECAST_RESULT_INDEX_WILDCARD = 'opensearch-forecast-results*';
const CUSTOM_FORECAST_RESULT_INDEX_PREFIX = exports.CUSTOM_FORECAST_RESULT_INDEX_PREFIX = 'opensearch-forecast-result-';
const CUSTOM_FORECAST_RESULT_INDEX_WILDCARD = exports.CUSTOM_FORECAST_RESULT_INDEX_WILDCARD = `${CUSTOM_FORECAST_RESULT_INDEX_PREFIX}*`;
const API = exports.API = {
  DETECTOR_BASE: `${AD_API_ROUTE_PREFIX}/detectors`,
  ALERTING_BASE: `${ALERTING_API_ROUTE_PREFIX}/monitors`,
  FORECASTER_BASE: `${FORECAST_API_ROUTE_PREFIX}/forecasters`,
  FORECAST_RESULT_SEARCH: `/${DEFAULT_FORECAST_RESULT_INDEX_WILDCARD}/_search`
};
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json',
  'User-Agent': 'OpenSearch Dashboards'
};
const SEC_IN_MILLI_SECS = exports.SEC_IN_MILLI_SECS = 1000;
const MIN_IN_MILLI_SECS = exports.MIN_IN_MILLI_SECS = 60 * SEC_IN_MILLI_SECS;
const HOUR_IN_MILLI_SECS = exports.HOUR_IN_MILLI_SECS = 60 * MIN_IN_MILLI_SECS;
const DAY_IN_MILLI_SECS = exports.DAY_IN_MILLI_SECS = 24 * HOUR_IN_MILLI_SECS;
const WEEK_IN_MILLI_SECS = exports.WEEK_IN_MILLI_SECS = 7 * DAY_IN_MILLI_SECS;
let CLUSTER = exports.CLUSTER = /*#__PURE__*/function (CLUSTER) {
  CLUSTER["ADMIN"] = "admin";
  CLUSTER["AES_AD"] = "aes_ad";
  CLUSTER["DATA"] = "data";
  return CLUSTER;
}({});
let SORT_DIRECTION = exports.SORT_DIRECTION = /*#__PURE__*/function (SORT_DIRECTION) {
  SORT_DIRECTION["ASC"] = "asc";
  SORT_DIRECTION["DESC"] = "desc";
  return SORT_DIRECTION;
}({});
let DETECTORS_QUERY_PARAMS = exports.DETECTORS_QUERY_PARAMS = /*#__PURE__*/function (DETECTORS_QUERY_PARAMS) {
  DETECTORS_QUERY_PARAMS["FROM"] = "from";
  DETECTORS_QUERY_PARAMS["SIZE"] = "size";
  DETECTORS_QUERY_PARAMS["SEARCH"] = "search";
  DETECTORS_QUERY_PARAMS["INDICES"] = "indices";
  DETECTORS_QUERY_PARAMS["SORT_FIELD"] = "sortField";
  DETECTORS_QUERY_PARAMS["SORT_DIRECTION"] = "sortDirection";
  DETECTORS_QUERY_PARAMS["NAME"] = "name";
  DETECTORS_QUERY_PARAMS["DATASOURCEID"] = "dataSourceId";
  return DETECTORS_QUERY_PARAMS;
}({});
let AD_DOC_FIELDS = exports.AD_DOC_FIELDS = /*#__PURE__*/function (AD_DOC_FIELDS) {
  AD_DOC_FIELDS["DATA_START_TIME"] = "data_start_time";
  AD_DOC_FIELDS["DATA_END_TIME"] = "data_end_time";
  AD_DOC_FIELDS["DETECTOR_ID"] = "detector_id";
  AD_DOC_FIELDS["TASK_ID"] = "task_id";
  AD_DOC_FIELDS["DETECTOR_NAME"] = "name";
  AD_DOC_FIELDS["PLOT_TIME"] = "plot_time";
  AD_DOC_FIELDS["ANOMALY_GRADE"] = "anomaly_grade";
  AD_DOC_FIELDS["ERROR"] = "error";
  AD_DOC_FIELDS["INDICES"] = "indices";
  return AD_DOC_FIELDS;
}({});
const MAX_DETECTORS = exports.MAX_DETECTORS = 1000;
const MAX_FORECASTER = exports.MAX_FORECASTER = 1000;
const MAX_MONITORS = exports.MAX_MONITORS = 1000;
const MAX_ALERTS = exports.MAX_ALERTS = 1000;

// TODO: maybe move types/interfaces/constants/helpers shared between client and server
// side as many as possible into single place
let DETECTOR_STATE = exports.DETECTOR_STATE = /*#__PURE__*/function (DETECTOR_STATE) {
  DETECTOR_STATE["DISABLED"] = "Stopped";
  DETECTOR_STATE["INIT"] = "Initializing";
  DETECTOR_STATE["RUNNING"] = "Running";
  DETECTOR_STATE["FINISHED"] = "Finished";
  DETECTOR_STATE["FEATURE_REQUIRED"] = "Feature required";
  DETECTOR_STATE["INIT_FAILURE"] = "Initialization failure";
  DETECTOR_STATE["UNEXPECTED_FAILURE"] = "Unexpected failure";
  DETECTOR_STATE["FAILED"] = "Failed";
  return DETECTOR_STATE;
}({}); // The keys are INACTIVE_STOPPED, etc.
// The values are Inactive, etc.
let FORECASTER_STATE = exports.FORECASTER_STATE = /*#__PURE__*/function (FORECASTER_STATE) {
  FORECASTER_STATE["INACTIVE_STOPPED"] = "Inactive stopped";
  FORECASTER_STATE["INACTIVE_NOT_STARTED"] = "Inactive not started";
  FORECASTER_STATE["AWAITING_DATA_TO_INIT"] = "Awaiting data to init";
  FORECASTER_STATE["AWAITING_DATA_TO_RESTART"] = "Awaiting data to restart";
  FORECASTER_STATE["INIT_TEST"] = "Initializing test";
  FORECASTER_STATE["INITIALIZING_FORECAST"] = "Initializing forecast";
  FORECASTER_STATE["TEST_COMPLETE"] = "Test complete";
  FORECASTER_STATE["RUNNING"] = "Running";
  FORECASTER_STATE["INIT_ERROR"] = "Init forecast failure";
  FORECASTER_STATE["FORECAST_FAILURE"] = "Forecast failure";
  FORECASTER_STATE["INIT_TEST_FAILED"] = "Init test failure";
  return FORECASTER_STATE;
}({});
let FORECASTER_STATE_DISPLAY = exports.FORECASTER_STATE_DISPLAY = /*#__PURE__*/function (FORECASTER_STATE_DISPLAY) {
  FORECASTER_STATE_DISPLAY["INACTIVE_STOPPED"] = "Inactive";
  FORECASTER_STATE_DISPLAY["INACTIVE_NOT_STARTED"] = "Inactive";
  FORECASTER_STATE_DISPLAY["AWAITING_DATA_TO_INIT"] = "Awaiting data";
  FORECASTER_STATE_DISPLAY["AWAITING_DATA_TO_RESTART"] = "Awaiting data";
  FORECASTER_STATE_DISPLAY["INITIALIZING_TEST"] = "Initializing...";
  FORECASTER_STATE_DISPLAY["INITIALIZING_FORECAST"] = "Initializing...";
  FORECASTER_STATE_DISPLAY["TEST_COMPLETE"] = "Test complete";
  FORECASTER_STATE_DISPLAY["RUNNING"] = "Running";
  FORECASTER_STATE_DISPLAY["INIT_FORECAST_FAILURE"] = "Error";
  FORECASTER_STATE_DISPLAY["FORECAST_FAILURE"] = "Error";
  FORECASTER_STATE_DISPLAY["INIT_TEST_FAILURE"] = "Error";
  return FORECASTER_STATE_DISPLAY;
}({});
const FORECASTER_STATE_TO_DISPLAY = exports.FORECASTER_STATE_TO_DISPLAY = {
  [FORECASTER_STATE.INACTIVE_STOPPED]: FORECASTER_STATE_DISPLAY.INACTIVE_STOPPED,
  [FORECASTER_STATE.INACTIVE_NOT_STARTED]: FORECASTER_STATE_DISPLAY.INACTIVE_NOT_STARTED,
  [FORECASTER_STATE.AWAITING_DATA_TO_INIT]: FORECASTER_STATE_DISPLAY.AWAITING_DATA_TO_INIT,
  [FORECASTER_STATE.AWAITING_DATA_TO_RESTART]: FORECASTER_STATE_DISPLAY.AWAITING_DATA_TO_RESTART,
  [FORECASTER_STATE.INIT_TEST]: FORECASTER_STATE_DISPLAY.INITIALIZING_TEST,
  [FORECASTER_STATE.INITIALIZING_FORECAST]: FORECASTER_STATE_DISPLAY.INITIALIZING_FORECAST,
  [FORECASTER_STATE.TEST_COMPLETE]: FORECASTER_STATE_DISPLAY.TEST_COMPLETE,
  [FORECASTER_STATE.RUNNING]: FORECASTER_STATE_DISPLAY.RUNNING,
  [FORECASTER_STATE.INIT_ERROR]: FORECASTER_STATE_DISPLAY.INIT_FORECAST_FAILURE,
  [FORECASTER_STATE.FORECAST_FAILURE]: FORECASTER_STATE_DISPLAY.FORECAST_FAILURE,
  [FORECASTER_STATE.INIT_TEST_FAILED]: FORECASTER_STATE_DISPLAY.INIT_TEST_FAILURE
};
let SAMPLE_TYPE = exports.SAMPLE_TYPE = /*#__PURE__*/function (SAMPLE_TYPE) {
  SAMPLE_TYPE["HTTP_RESPONSES"] = "http-responses";
  SAMPLE_TYPE["HOST_HEALTH"] = "host-health";
  SAMPLE_TYPE["ECOMMERCE"] = "ecommerce";
  return SAMPLE_TYPE;
}({});
const ENTITY_FIELD = exports.ENTITY_FIELD = 'entity';
const ENTITY_VALUE_PATH_FIELD = exports.ENTITY_VALUE_PATH_FIELD = 'entity.value';
const ENTITY_NAME_PATH_FIELD = exports.ENTITY_NAME_PATH_FIELD = 'entity.name';
const MODEL_ID_FIELD = exports.MODEL_ID_FIELD = 'model_id';
const DOC_COUNT_FIELD = exports.DOC_COUNT_FIELD = 'doc_count';
const KEY_FIELD = exports.KEY_FIELD = 'key';
const ENTITY_LIST_FIELD = exports.ENTITY_LIST_FIELD = 'entity_list';
const MAX_ANOMALY_GRADE_FIELD = exports.MAX_ANOMALY_GRADE_FIELD = 'max_anomaly_grade';

// y-axis values in the heatmap chart should be in the form:
// <category-field-value-1><br><category-field-value-2>
const ENTITY_LIST_DELIMITER = exports.ENTITY_LIST_DELIMITER = '<br>';

// when hovering over a cell, the entity list should be in the form:
// <category-field-name-1>: <category-field-value-1>, <category-field-name-2>: <category-field-value-2>
const HEATMAP_CELL_ENTITY_DELIMITER = exports.HEATMAP_CELL_ENTITY_DELIMITER = ', ';
const HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = exports.HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = ': ';
const STACK_TRACE_PATTERN = exports.STACK_TRACE_PATTERN = '.java:';
const OPENSEARCH_EXCEPTION_PREFIX = exports.OPENSEARCH_EXCEPTION_PREFIX = 'org.opensearch.OpenSearchException: ';
const REALTIME_TASK_TYPE_PREFIX = exports.REALTIME_TASK_TYPE_PREFIX = 'REALTIME';
const HISTORICAL_TASK_TYPE_PREFIX = exports.HISTORICAL_TASK_TYPE_PREFIX = 'HISTORICAL';
const REALTIME_TASK_TYPES = exports.REALTIME_TASK_TYPES = ['REALTIME_HC_DETECTOR', 'REALTIME_SINGLE_ENTITY'];
const HISTORICAL_TASK_TYPES = exports.HISTORICAL_TASK_TYPES = ['HISTORICAL_SINGLE_ENTITY', 'HISTORICAL_HC_DETECTOR', 'HISTORICAL'];
const FORECAST_REALTIME_TASK_TYPES = exports.FORECAST_REALTIME_TASK_TYPES = ['REALTIME_FORECAST_HC_FORECASTER', 'REALTIME_FORECAST_SINGLE_STREAM'];
const FORECAST_RUN_ONCE_TASK_TYPES = exports.FORECAST_RUN_ONCE_TASK_TYPES = ['RUN_ONCE_FORECAST_HC_FORECASTER', 'RUN_ONCE_FORECAST_SINGLE_STREAM'];
const CUSTOM_AD_RESULT_INDEX_PREFIX = exports.CUSTOM_AD_RESULT_INDEX_PREFIX = 'opensearch-ad-plugin-result-';
const CUSTOM_FORECASTER_RESULT_INDEX_PREFIX = exports.CUSTOM_FORECASTER_RESULT_INDEX_PREFIX = 'opensearch-forecast-result-';
const SUGGEST_ANOMALY_DETECTOR_CONFIG_ID = exports.SUGGEST_ANOMALY_DETECTOR_CONFIG_ID = 'os_suggest_ad';
let FORECASTER_DOC_FIELDS = exports.FORECASTER_DOC_FIELDS = /*#__PURE__*/function (FORECASTER_DOC_FIELDS) {
  FORECASTER_DOC_FIELDS["DATA_START_TIME"] = "data_start_time";
  FORECASTER_DOC_FIELDS["DATA_END_TIME"] = "data_end_time";
  FORECASTER_DOC_FIELDS["FORECASTER_ID"] = "forecaster_id";
  FORECASTER_DOC_FIELDS["TASK_ID"] = "task_id";
  FORECASTER_DOC_FIELDS["FORECASTER_NAME"] = "name";
  FORECASTER_DOC_FIELDS["PLOT_TIME"] = "plot_time";
  FORECASTER_DOC_FIELDS["FORECAST_VALUE"] = "forecast_value";
  FORECASTER_DOC_FIELDS["FORECAST_LOWER_BOUND"] = "forecast_lower_bound";
  FORECASTER_DOC_FIELDS["FORECAST_UPPER_BOUND"] = "forecast_upper_bound";
  FORECASTER_DOC_FIELDS["ERROR"] = "error";
  FORECASTER_DOC_FIELDS["INDICES"] = "indices";
  FORECASTER_DOC_FIELDS["EXECUTION_END_TIME"] = "execution_end_time";
  FORECASTER_DOC_FIELDS["FORECAST_DATA_END_TIME"] = "forecast_data_end_time";
  return FORECASTER_DOC_FIELDS;
}({});
const isForecasterErrorState = state => {
  return [FORECASTER_STATE.INIT_ERROR, FORECASTER_STATE.FORECAST_FAILURE, FORECASTER_STATE.INIT_TEST_FAILED].includes(state);
};
exports.isForecasterErrorState = isForecasterErrorState;
function isActiveState(state) {
  if (!state) return false;
  return state.startsWith('AWAITING_') || state === FORECASTER_STATE.RUNNING || state === FORECASTER_STATE.INITIALIZING_FORECAST || state === FORECASTER_STATE.FORECAST_FAILURE;
}
function isTestState(state) {
  return state === FORECASTER_STATE.INIT_TEST || state === FORECASTER_STATE.TEST_COMPLETE;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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