"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnomalyDetectionUiSettings = getAnomalyDetectionUiSettings;
var _configSchema = require("@osd/config-schema");
var _i18n = require("@osd/i18n");
var _constants = require("../utils/constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/**
 * UI settings for Detection Insights
 */
function getAnomalyDetectionUiSettings() {
  return {
    [_constants.DAILY_INSIGHTS_ENABLED]: {
      name: _i18n.i18n.translate('anomalyDetection.uiSettings.dailyInsightsEnabled.title', {
        defaultMessage: 'Enable Daily Insights'
      }),
      value: false,
      description: _i18n.i18n.translate('anomalyDetection.uiSettings.dailyInsightsEnabled.description', {
        defaultMessage: 'Enable or disable the Daily Insights feature. Daily Insights uses algorithms to analyze and summarize correlated anomalies across your detectors. Note: The backend cluster setting "plugins.anomaly_detection.insights_enabled" must also be enabled.'
      }),
      category: ['Detection Insights'],
      schema: _configSchema.schema.boolean(),
      requiresPageReload: true
    }
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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