"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertFieldCapsToMappingStructure = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const convertFieldCapsToMappingStructure = fieldCapsResponse => {
  let mappings = {};
  fieldCapsResponse.indices.forEach(index => {
    mappings[index] = {
      mappings: {
        properties: {}
      }
    };
  });
  for (const [fieldName, fieldDetails] of Object.entries(fieldCapsResponse.fields)) {
    if (fieldName.startsWith('_')) {
      continue;
    }
    for (const [fieldType, typeDetails] of Object.entries(fieldDetails)) {
      if (fieldType == 'unmapped') {
        continue;
      }
      let mapped_indices = _lodash.default.get(typeDetails, 'indices', fieldCapsResponse.indices);
      mapped_indices.forEach(mappedIndex => {
        mappings[mappedIndex]['mappings']['properties'][fieldName] = {
          type: typeDetails.type
        };
      });
    }
  }
  return mappings;
};
exports.convertFieldCapsToMappingStructure = convertFieldCapsToMappingStructure;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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