"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.registerSampleDataRoutes = registerSampleDataRoutes;
var _path = _interopRequireDefault(require("path"));
var _constants = require("../utils/constants");
var _helpers = require("../sampleData/utils/helpers");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                          * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                          * compatible open source license.
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                          * GitHub history for details.
                                                                                                                                                                                                                                                                                                                          */ //@ts-ignore
function registerSampleDataRoutes(apiRouter, sampleDataService) {
  apiRouter.post('/create_sample_data/{type}', sampleDataService.createSampleData);
  apiRouter.post('/create_sample_data/{type}/{dataSourceId}', sampleDataService.createSampleData);
}
class SampleDataService {
  constructor(client, dataSourceEnabled) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    // Get the zip file stored in server, unzip it, and bulk insert it
    _defineProperty(this, "createSampleData", async (context, request, opensearchDashboardsResponse) => {
      //@ts-ignore
      const type = request.params.type;
      try {
        let filePath = '';
        let indexName = '';
        switch (type) {
          case _constants.SAMPLE_TYPE.HTTP_RESPONSES:
            {
              filePath = _path.default.resolve(__dirname, '../sampleData/rawData/httpResponses.json.gz');
              indexName = 'sample-http-responses';
              break;
            }
          case _constants.SAMPLE_TYPE.ECOMMERCE:
            {
              filePath = _path.default.resolve(__dirname, '../sampleData/rawData/ecommerce.json.gz');
              indexName = 'sample-ecommerce';
              break;
            }
          case _constants.SAMPLE_TYPE.HOST_HEALTH:
            {
              filePath = _path.default.resolve(__dirname, '../sampleData/rawData/hostHealth.json.gz');
              indexName = 'sample-host-health';
              break;
            }
        }
        await (0, _helpers.loadSampleData)(filePath, indexName, this.client, request, context, this.dataSourceEnabled);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true
          }
        });
      } catch (err) {
        console.log('Anomaly detector - Unable to load the sample data', err);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    this.client = client;
    this.dataSourceEnabled = dataSourceEnabled;
  }
}
exports.default = SampleDataService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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