"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.registerMLRoutes = registerMLRoutes;
var _helpers = require("../utils/helpers");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                          * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                          * compatible open source license.
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                          * GitHub history for details.
                                                                                                                                                                                                                                                                                                                          */
function registerMLRoutes(apiRouter, mlService) {
  apiRouter.post('/agents/{agentId}/execute', mlService.executeAgent);
  apiRouter.post('/agents/{agentId}/execute/{dataSourceId}', mlService.executeAgent);
}
class MLService {
  constructor(client, dataSourceEnabled) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    _defineProperty(this, "executeAgent", async (context, request, opensearchDashboardsResponse) => {
      try {
        const {
          agentId,
          dataSourceId = ''
        } = request.params;
        const {
          indices
        } = request.body;
        const callWithRequest = (0, _helpers.getClientBasedOnDataSource)(context, this.dataSourceEnabled, request, dataSourceId, this.client);
        const requestBody = {
          parameters: {
            input: indices
          }
        };
        const response = await callWithRequest('ml.executeAgent', {
          agentId: agentId,
          async: true,
          body: requestBody
        });
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true,
            response: response
          }
        });
      } catch (err) {
        var _err$body, _err$body2;
        console.log('ML - execute agent failed', err);
        const errorDetails = (err === null || err === void 0 || (_err$body = err.body) === null || _err$body === void 0 || (_err$body = _err$body.error) === null || _err$body === void 0 ? void 0 : _err$body.details) || (err === null || err === void 0 || (_err$body2 = err.body) === null || _err$body2 === void 0 || (_err$body2 = _err$body2.error) === null || _err$body2 === void 0 ? void 0 : _err$body2.reason);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: errorDetails
          }
        });
      }
    });
    this.client = client;
    this.dataSourceEnabled = dataSourceEnabled;
  }
}
exports.default = MLService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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