"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.registerAlertingRoutes = registerAlertingRoutes;
var _lodash = require("lodash");
var _constants = require("../utils/constants");
var _adHelpers = require("./utils/adHelpers");
var _helpers = require("../utils/helpers");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                          * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                          * compatible open source license.
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                          * GitHub history for details.
                                                                                                                                                                                                                                                                                                                          */ //@ts-ignore
function registerAlertingRoutes(apiRouter, alertingService) {
  apiRouter.post('/monitors/_search', alertingService.searchMonitors);
  apiRouter.post('/monitors/_search/{dataSourceId}', alertingService.searchMonitors);
  apiRouter.get('/monitors/alerts', alertingService.searchAlerts);
  apiRouter.get('/monitors/alerts/{dataSourceId}', alertingService.searchAlerts);
}
class AlertingService {
  constructor(client, dataSourceEnabled) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    _defineProperty(this, "searchMonitors", async (context, request, opensearchDashboardsResponse) => {
      try {
        const {
          dataSourceId = ''
        } = request.params;
        const requestBody = {
          size: _constants.MAX_MONITORS,
          query: {
            nested: {
              path: 'monitor.inputs',
              query: {
                bool: {
                  should: [{
                    term: {
                      'monitor.inputs.search.indices.keyword': {
                        value: '.opendistro-anomaly-results*'
                      }
                    }
                  }, {
                    match_phrase_prefix: {
                      'monitor.inputs.search.indices': 'opensearch-ad-plugin-result-'
                    }
                  }]
                }
              }
            }
          }
        };
        const callWithRequest = (0, _helpers.getClientBasedOnDataSource)(context, this.dataSourceEnabled, request, dataSourceId, this.client);
        const response = await callWithRequest('adAlerting.searchMonitors', {
          body: requestBody
        });
        const totalMonitors = (0, _lodash.get)(response, 'hits.total.value', 0);
        const allMonitors = (0, _lodash.get)(response, 'hits.hits', []).reduce((acc, monitor) => ({
          ...acc,
          [monitor._id]: {
            id: monitor._id,
            name: (0, _lodash.get)(monitor, '_source.name'),
            enabled: (0, _lodash.get)(monitor, '_source.enabled', false),
            enabledTime: (0, _lodash.get)(monitor, '_source.enabled_time'),
            schedule: (0, _lodash.get)(monitor, '_source.schedule'),
            inputs: (0, _lodash.get)(monitor, '_source.inputs'),
            triggers: (0, _lodash.get)(monitor, '_source.triggers'),
            lastUpdateTime: (0, _lodash.get)(monitor, '_source.last_update_time')
          }
        }), {});
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true,
            response: {
              totalMonitors,
              monitors: Object.values(allMonitors)
            }
          }
        });
      } catch (err) {
        console.log('Unable to get monitor on top of detector', err);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: (0, _adHelpers.getErrorMessage)(err)
          }
        });
      }
    });
    _defineProperty(this, "searchAlerts", async (context, request, opensearchDashboardsResponse) => {
      try {
        const {
          monitorId,
          startTime,
          endTime
        } = request.query;
        const {
          dataSourceId = ''
        } = request.params;
        const callWithRequest = (0, _helpers.getClientBasedOnDataSource)(context, this.dataSourceEnabled, request, dataSourceId, this.client);
        const response = callWithRequest('adAlerting.searchAlerts', {
          monitorId: monitorId,
          startTime: startTime,
          endTime: endTime
        });
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true,
            response
          }
        });
      } catch (err) {
        console.log('Unable to search alerts', err);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: (0, _adHelpers.getErrorMessage)(err)
          }
        });
      }
    });
    this.client = client;
    this.dataSourceEnabled = dataSourceEnabled;
  }
}
exports.default = AlertingService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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