"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _configSchema = require("@osd/config-schema");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
// Router factory
var _default = (iRouter, basePath) => {
  if (basePath == null || basePath == '') {
    throw new TypeError('Base path is null');
  }
  const requestHandler = handler => async (context, request, response) => {
    try {
      return await handler(context, request, response);
    } catch (e) {
      throw e;
    }
  };
  return ['get', 'put', 'post', 'delete'].reduce((router, method) => {
    router[method] = (path, handler) => {
      switch (method) {
        case 'get':
          {
            iRouter.get({
              path: `${basePath}${path}`,
              validate: {
                params: _configSchema.schema.any(),
                query: _configSchema.schema.any()
              }
            }, requestHandler(handler));
            break;
          }
        case 'put':
          {
            iRouter.put({
              path: `${basePath}${path}`,
              validate: {
                params: _configSchema.schema.any(),
                query: _configSchema.schema.any(),
                body: _configSchema.schema.any()
              }
            }, requestHandler(handler));
            break;
          }
        case 'post':
          {
            iRouter.post({
              path: `${basePath}${path}`,
              validate: {
                params: _configSchema.schema.any(),
                query: _configSchema.schema.any(),
                body: _configSchema.schema.any()
              }
            }, requestHandler(handler));
            break;
          }
        case 'delete':
          {
            iRouter.delete({
              path: `${basePath}${path}`,
              validate: {
                params: _configSchema.schema.any(),
                query: _configSchema.schema.any(),
                body: _configSchema.schema.any()
              }
            }, requestHandler(handler));
            break;
          }
        default:
          {
            break;
          }
      }
    };
    return router;
  }, {});
};
exports.default = _default;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9kZWZhdWx0IiwiaVJvdXRlciIsImJhc2VQYXRoIiwiVHlwZUVycm9yIiwicmVxdWVzdEhhbmRsZXIiLCJoYW5kbGVyIiwiY29udGV4dCIsInJlcXVlc3QiLCJyZXNwb25zZSIsImUiLCJyZWR1Y2UiLCJyb3V0ZXIiLCJtZXRob2QiLCJwYXRoIiwiZ2V0IiwidmFsaWRhdGUiLCJwYXJhbXMiLCJzY2hlbWEiLCJhbnkiLCJxdWVyeSIsInB1dCIsImJvZHkiLCJwb3N0IiwiZGVsZXRlIiwiZXhwb3J0cyIsImRlZmF1bHQiLCJtb2R1bGUiXSwic291cmNlcyI6WyJyb3V0ZXIudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcclxuICpcclxuICogVGhlIE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzIHJlcXVpcmUgY29udHJpYnV0aW9ucyBtYWRlIHRvXHJcbiAqIHRoaXMgZmlsZSBiZSBsaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlLTIuMCBsaWNlbnNlIG9yIGFcclxuICogY29tcGF0aWJsZSBvcGVuIHNvdXJjZSBsaWNlbnNlLlxyXG4gKlxyXG4gKiBNb2RpZmljYXRpb25zIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9ycy4gU2VlXHJcbiAqIEdpdEh1YiBoaXN0b3J5IGZvciBkZXRhaWxzLlxyXG4gKi9cclxuXHJcbmltcG9ydCB7XHJcbiAgSVJvdXRlcixcclxuICBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXHJcbiAgT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxyXG4gIE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2VGYWN0b3J5LFxyXG4gIElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlLFxyXG59IGZyb20gJy4uLy4uLy4uL3NyYy9jb3JlL3NlcnZlcic7XHJcbmltcG9ydCB7IHNjaGVtYSB9IGZyb20gJ0Bvc2QvY29uZmlnLXNjaGVtYSc7XHJcblxyXG50eXBlIFJvdXRlSGFuZGxlciA9IChcclxuICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXHJcbiAgcmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxyXG4gIHJlc3BvbnNlOiBPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlRmFjdG9yeVxyXG4pID0+IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8YW55Pj47XHJcblxyXG50eXBlIFJvdXRlID0gKHBhdGg6IHN0cmluZywgaGFuZGxlcjogUm91dGVIYW5kbGVyKSA9PiBSb3V0ZXI7XHJcblxyXG5leHBvcnQgaW50ZXJmYWNlIFJvdXRlciB7XHJcbiAgZ2V0OiBSb3V0ZTtcclxuICBwb3N0OiBSb3V0ZTtcclxuICBwdXQ6IFJvdXRlO1xyXG4gIGRlbGV0ZTogUm91dGU7XHJcbn1cclxuLy8gUm91dGVyIGZhY3RvcnlcclxuZXhwb3J0IGRlZmF1bHQgKGlSb3V0ZXI6IElSb3V0ZXIsIGJhc2VQYXRoOiBTdHJpbmcpOiBSb3V0ZXIgPT4ge1xyXG4gIGlmIChiYXNlUGF0aCA9PSBudWxsIHx8IGJhc2VQYXRoID09ICcnKSB7XHJcbiAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCdCYXNlIHBhdGggaXMgbnVsbCcpO1xyXG4gIH1cclxuICBjb25zdCByZXF1ZXN0SGFuZGxlciA9XHJcbiAgICAoaGFuZGxlcjogUm91dGVIYW5kbGVyKSA9PlxyXG4gICAgYXN5bmMgKFxyXG4gICAgICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXHJcbiAgICAgIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcclxuICAgICAgcmVzcG9uc2U6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2VGYWN0b3J5XHJcbiAgICApID0+IHtcclxuICAgICAgdHJ5IHtcclxuICAgICAgICByZXR1cm4gYXdhaXQgaGFuZGxlcihjb250ZXh0LCByZXF1ZXN0LCByZXNwb25zZSk7XHJcbiAgICAgIH0gY2F0Y2ggKGUpIHtcclxuICAgICAgICB0aHJvdyBlO1xyXG4gICAgICB9XHJcbiAgICB9O1xyXG4gIHJldHVybiBbJ2dldCcsICdwdXQnLCAncG9zdCcsICdkZWxldGUnXS5yZWR1Y2UoXHJcbiAgICAocm91dGVyOiBhbnksIG1ldGhvZDogc3RyaW5nKSA9PiB7XHJcbiAgICAgIHJvdXRlclttZXRob2RdID0gKHBhdGg6IFN0cmluZywgaGFuZGxlcjogUm91dGVIYW5kbGVyKSA9PiB7XHJcbiAgICAgICAgc3dpdGNoIChtZXRob2QpIHtcclxuICAgICAgICAgIGNhc2UgJ2dldCc6IHtcclxuICAgICAgICAgICAgaVJvdXRlci5nZXQoXHJcbiAgICAgICAgICAgICAge1xyXG4gICAgICAgICAgICAgICAgcGF0aDogYCR7YmFzZVBhdGh9JHtwYXRofWAsXHJcbiAgICAgICAgICAgICAgICB2YWxpZGF0ZToge1xyXG4gICAgICAgICAgICAgICAgICBwYXJhbXM6IHNjaGVtYS5hbnkoKSxcclxuICAgICAgICAgICAgICAgICAgcXVlcnk6IHNjaGVtYS5hbnkoKSxcclxuICAgICAgICAgICAgICAgIH0sXHJcbiAgICAgICAgICAgICAgfSxcclxuICAgICAgICAgICAgICByZXF1ZXN0SGFuZGxlcihoYW5kbGVyKVxyXG4gICAgICAgICAgICApO1xyXG4gICAgICAgICAgICBicmVhaztcclxuICAgICAgICAgIH1cclxuICAgICAgICAgIGNhc2UgJ3B1dCc6IHtcclxuICAgICAgICAgICAgaVJvdXRlci5wdXQoXHJcbiAgICAgICAgICAgICAge1xyXG4gICAgICAgICAgICAgICAgcGF0aDogYCR7YmFzZVBhdGh9JHtwYXRofWAsXHJcbiAgICAgICAgICAgICAgICB2YWxpZGF0ZToge1xyXG4gICAgICAgICAgICAgICAgICBwYXJhbXM6IHNjaGVtYS5hbnkoKSxcclxuICAgICAgICAgICAgICAgICAgcXVlcnk6IHNjaGVtYS5hbnkoKSxcclxuICAgICAgICAgICAgICAgICAgYm9keTogc2NoZW1hLmFueSgpLFxyXG4gICAgICAgICAgICAgICAgfSxcclxuICAgICAgICAgICAgICB9LFxyXG4gICAgICAgICAgICAgIHJlcXVlc3RIYW5kbGVyKGhhbmRsZXIpXHJcbiAgICAgICAgICAgICk7XHJcbiAgICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgICAgfVxyXG4gICAgICAgICAgY2FzZSAncG9zdCc6IHtcclxuICAgICAgICAgICAgaVJvdXRlci5wb3N0KFxyXG4gICAgICAgICAgICAgIHtcclxuICAgICAgICAgICAgICAgIHBhdGg6IGAke2Jhc2VQYXRofSR7cGF0aH1gLFxyXG4gICAgICAgICAgICAgICAgdmFsaWRhdGU6IHtcclxuICAgICAgICAgICAgICAgICAgcGFyYW1zOiBzY2hlbWEuYW55KCksXHJcbiAgICAgICAgICAgICAgICAgIHF1ZXJ5OiBzY2hlbWEuYW55KCksXHJcbiAgICAgICAgICAgICAgICAgIGJvZHk6IHNjaGVtYS5hbnkoKSxcclxuICAgICAgICAgICAgICAgIH0sXHJcbiAgICAgICAgICAgICAgfSxcclxuICAgICAgICAgICAgICByZXF1ZXN0SGFuZGxlcihoYW5kbGVyKVxyXG4gICAgICAgICAgICApO1xyXG4gICAgICAgICAgICBicmVhaztcclxuICAgICAgICAgIH1cclxuICAgICAgICAgIGNhc2UgJ2RlbGV0ZSc6IHtcclxuICAgICAgICAgICAgaVJvdXRlci5kZWxldGUoXHJcbiAgICAgICAgICAgICAge1xyXG4gICAgICAgICAgICAgICAgcGF0aDogYCR7YmFzZVBhdGh9JHtwYXRofWAsXHJcbiAgICAgICAgICAgICAgICB2YWxpZGF0ZToge1xyXG4gICAgICAgICAgICAgICAgICBwYXJhbXM6IHNjaGVtYS5hbnkoKSxcclxuICAgICAgICAgICAgICAgICAgcXVlcnk6IHNjaGVtYS5hbnkoKSxcclxuICAgICAgICAgICAgICAgICAgYm9keTogc2NoZW1hLmFueSgpLFxyXG4gICAgICAgICAgICAgICAgfSxcclxuICAgICAgICAgICAgICB9LFxyXG4gICAgICAgICAgICAgIHJlcXVlc3RIYW5kbGVyKGhhbmRsZXIpXHJcbiAgICAgICAgICAgICk7XHJcbiAgICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgICAgfVxyXG4gICAgICAgICAgZGVmYXVsdDoge1xyXG4gICAgICAgICAgICBicmVhaztcclxuICAgICAgICAgIH1cclxuICAgICAgICB9XHJcbiAgICAgIH07XHJcbiAgICAgIHJldHVybiByb3V0ZXI7XHJcbiAgICB9LFxyXG4gICAge31cclxuICApO1xyXG59O1xyXG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQWtCQSxJQUFBQSxhQUFBLEdBQUFDLE9BQUE7QUFsQkE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUF5QkE7QUFBQSxJQUFBQyxRQUFBLEdBQ2VBLENBQUNDLE9BQWdCLEVBQUVDLFFBQWdCLEtBQWE7RUFDN0QsSUFBSUEsUUFBUSxJQUFJLElBQUksSUFBSUEsUUFBUSxJQUFJLEVBQUUsRUFBRTtJQUN0QyxNQUFNLElBQUlDLFNBQVMsQ0FBQyxtQkFBbUIsQ0FBQztFQUMxQztFQUNBLE1BQU1DLGNBQWMsR0FDakJDLE9BQXFCLElBQ3RCLE9BQ0VDLE9BQThCLEVBQzlCQyxPQUFvQyxFQUNwQ0MsUUFBNkMsS0FDMUM7SUFDSCxJQUFJO01BQ0YsT0FBTyxNQUFNSCxPQUFPLENBQUNDLE9BQU8sRUFBRUMsT0FBTyxFQUFFQyxRQUFRLENBQUM7SUFDbEQsQ0FBQyxDQUFDLE9BQU9DLENBQUMsRUFBRTtNQUNWLE1BQU1BLENBQUM7SUFDVDtFQUNGLENBQUM7RUFDSCxPQUFPLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxNQUFNLEVBQUUsUUFBUSxDQUFDLENBQUNDLE1BQU0sQ0FDNUMsQ0FBQ0MsTUFBVyxFQUFFQyxNQUFjLEtBQUs7SUFDL0JELE1BQU0sQ0FBQ0MsTUFBTSxDQUFDLEdBQUcsQ0FBQ0MsSUFBWSxFQUFFUixPQUFxQixLQUFLO01BQ3hELFFBQVFPLE1BQU07UUFDWixLQUFLLEtBQUs7VUFBRTtZQUNWWCxPQUFPLENBQUNhLEdBQUcsQ0FDVDtjQUNFRCxJQUFJLEVBQUcsR0FBRVgsUUFBUyxHQUFFVyxJQUFLLEVBQUM7Y0FDMUJFLFFBQVEsRUFBRTtnQkFDUkMsTUFBTSxFQUFFQyxvQkFBTSxDQUFDQyxHQUFHLENBQUMsQ0FBQztnQkFDcEJDLEtBQUssRUFBRUYsb0JBQU0sQ0FBQ0MsR0FBRyxDQUFDO2NBQ3BCO1lBQ0YsQ0FBQyxFQUNEZCxjQUFjLENBQUNDLE9BQU8sQ0FDeEIsQ0FBQztZQUNEO1VBQ0Y7UUFDQSxLQUFLLEtBQUs7VUFBRTtZQUNWSixPQUFPLENBQUNtQixHQUFHLENBQ1Q7Y0FDRVAsSUFBSSxFQUFHLEdBQUVYLFFBQVMsR0FBRVcsSUFBSyxFQUFDO2NBQzFCRSxRQUFRLEVBQUU7Z0JBQ1JDLE1BQU0sRUFBRUMsb0JBQU0sQ0FBQ0MsR0FBRyxDQUFDLENBQUM7Z0JBQ3BCQyxLQUFLLEVBQUVGLG9CQUFNLENBQUNDLEdBQUcsQ0FBQyxDQUFDO2dCQUNuQkcsSUFBSSxFQUFFSixvQkFBTSxDQUFDQyxHQUFHLENBQUM7Y0FDbkI7WUFDRixDQUFDLEVBQ0RkLGNBQWMsQ0FBQ0MsT0FBTyxDQUN4QixDQUFDO1lBQ0Q7VUFDRjtRQUNBLEtBQUssTUFBTTtVQUFFO1lBQ1hKLE9BQU8sQ0FBQ3FCLElBQUksQ0FDVjtjQUNFVCxJQUFJLEVBQUcsR0FBRVgsUUFBUyxHQUFFVyxJQUFLLEVBQUM7Y0FDMUJFLFFBQVEsRUFBRTtnQkFDUkMsTUFBTSxFQUFFQyxvQkFBTSxDQUFDQyxHQUFHLENBQUMsQ0FBQztnQkFDcEJDLEtBQUssRUFBRUYsb0JBQU0sQ0FBQ0MsR0FBRyxDQUFDLENBQUM7Z0JBQ25CRyxJQUFJLEVBQUVKLG9CQUFNLENBQUNDLEdBQUcsQ0FBQztjQUNuQjtZQUNGLENBQUMsRUFDRGQsY0FBYyxDQUFDQyxPQUFPLENBQ3hCLENBQUM7WUFDRDtVQUNGO1FBQ0EsS0FBSyxRQUFRO1VBQUU7WUFDYkosT0FBTyxDQUFDc0IsTUFBTSxDQUNaO2NBQ0VWLElBQUksRUFBRyxHQUFFWCxRQUFTLEdBQUVXLElBQUssRUFBQztjQUMxQkUsUUFBUSxFQUFFO2dCQUNSQyxNQUFNLEVBQUVDLG9CQUFNLENBQUNDLEdBQUcsQ0FBQyxDQUFDO2dCQUNwQkMsS0FBSyxFQUFFRixvQkFBTSxDQUFDQyxHQUFHLENBQUMsQ0FBQztnQkFDbkJHLElBQUksRUFBRUosb0JBQU0sQ0FBQ0MsR0FBRyxDQUFDO2NBQ25CO1lBQ0YsQ0FBQyxFQUNEZCxjQUFjLENBQUNDLE9BQU8sQ0FDeEIsQ0FBQztZQUNEO1VBQ0Y7UUFDQTtVQUFTO1lBQ1A7VUFDRjtNQUNGO0lBQ0YsQ0FBQztJQUNELE9BQU9NLE1BQU07RUFDZixDQUFDLEVBQ0QsQ0FBQyxDQUNILENBQUM7QUFDSCxDQUFDO0FBQUFhLE9BQUEsQ0FBQUMsT0FBQSxHQUFBekIsUUFBQTtBQUFBMEIsTUFBQSxDQUFBRixPQUFBLEdBQUFBLE9BQUEsQ0FBQUMsT0FBQSJ9