"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = exports.config = void 0;
exports.plugin = plugin;
var _configSchema = require("@osd/config-schema");
var _plugin = require("./plugin");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  })
});
const config = exports.config = {
  exposeToBrowser: {
    enabled: true
  },
  schema: configSchema
};
function plugin(initializerContext) {
  return new _plugin.AnomalyDetectionOpenSearchDashboardsPlugin(initializerContext);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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