"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = mlPlugin;
/*
 * SPDX-License-Identifier: Apache-2.0
 */

function mlPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.ml = components.clientAction.namespaceFactory();
  const ml = Client.prototype.ml.prototype;
  ml.executeAgent = ca({
    url: {
      fmt: `/_plugins/_ml/agents/<%=agentId%>/_execute?async=<%=async%>`,
      req: {
        agentId: {
          type: 'string',
          required: true
        },
        async: {
          type: 'boolean',
          required: false
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJtbFBsdWdpbiIsIkNsaWVudCIsImNvbmZpZyIsImNvbXBvbmVudHMiLCJjYSIsImNsaWVudEFjdGlvbiIsImZhY3RvcnkiLCJwcm90b3R5cGUiLCJtbCIsIm5hbWVzcGFjZUZhY3RvcnkiLCJleGVjdXRlQWdlbnQiLCJ1cmwiLCJmbXQiLCJyZXEiLCJhZ2VudElkIiwidHlwZSIsInJlcXVpcmVkIiwiYXN5bmMiLCJuZWVkQm9keSIsIm1ldGhvZCIsIm1vZHVsZSIsImV4cG9ydHMiLCJkZWZhdWx0Il0sInNvdXJjZXMiOlsibWxQbHVnaW4udHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcclxuICovXHJcblxyXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBtbFBsdWdpbihcclxuICBDbGllbnQ6IGFueSxcclxuICBjb25maWc6IGFueSxcclxuICBjb21wb25lbnRzOiBhbnlcclxuKSB7XHJcbiAgY29uc3QgY2EgPSBjb21wb25lbnRzLmNsaWVudEFjdGlvbi5mYWN0b3J5O1xyXG5cclxuICBDbGllbnQucHJvdG90eXBlLm1sID0gY29tcG9uZW50cy5jbGllbnRBY3Rpb24ubmFtZXNwYWNlRmFjdG9yeSgpO1xyXG4gIGNvbnN0IG1sID0gQ2xpZW50LnByb3RvdHlwZS5tbC5wcm90b3R5cGU7XHJcblxyXG4gIG1sLmV4ZWN1dGVBZ2VudCA9IGNhKHtcclxuICAgIHVybDoge1xyXG4gICAgICBmbXQ6IGAvX3BsdWdpbnMvX21sL2FnZW50cy88JT1hZ2VudElkJT4vX2V4ZWN1dGU/YXN5bmM9PCU9YXN5bmMlPmAsXHJcbiAgICAgIHJlcToge1xyXG4gICAgICAgIGFnZW50SWQ6IHtcclxuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxyXG4gICAgICAgICAgcmVxdWlyZWQ6IHRydWUsXHJcbiAgICAgICAgfSxcclxuICAgICAgICBhc3luYzoge1xyXG4gICAgICAgICAgdHlwZTogJ2Jvb2xlYW4nLFxyXG4gICAgICAgICAgcmVxdWlyZWQ6IGZhbHNlLFxyXG4gICAgICAgIH0sXHJcbiAgICAgIH0sXHJcbiAgICB9LFxyXG4gICAgbmVlZEJvZHk6IHRydWUsXHJcbiAgICBtZXRob2Q6ICdQT1NUJyxcclxuICB9KTtcclxufVxyXG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBO0FBQ0E7QUFDQTs7QUFFZSxTQUFTQSxRQUFRQSxDQUM5QkMsTUFBVyxFQUNYQyxNQUFXLEVBQ1hDLFVBQWUsRUFDZjtFQUNBLE1BQU1DLEVBQUUsR0FBR0QsVUFBVSxDQUFDRSxZQUFZLENBQUNDLE9BQU87RUFFMUNMLE1BQU0sQ0FBQ00sU0FBUyxDQUFDQyxFQUFFLEdBQUdMLFVBQVUsQ0FBQ0UsWUFBWSxDQUFDSSxnQkFBZ0IsQ0FBQyxDQUFDO0VBQ2hFLE1BQU1ELEVBQUUsR0FBR1AsTUFBTSxDQUFDTSxTQUFTLENBQUNDLEVBQUUsQ0FBQ0QsU0FBUztFQUV4Q0MsRUFBRSxDQUFDRSxZQUFZLEdBQUdOLEVBQUUsQ0FBQztJQUNuQk8sR0FBRyxFQUFFO01BQ0hDLEdBQUcsRUFBRyw2REFBNEQ7TUFDbEVDLEdBQUcsRUFBRTtRQUNIQyxPQUFPLEVBQUU7VUFDUEMsSUFBSSxFQUFFLFFBQVE7VUFDZEMsUUFBUSxFQUFFO1FBQ1osQ0FBQztRQUNEQyxLQUFLLEVBQUU7VUFDTEYsSUFBSSxFQUFFLFNBQVM7VUFDZkMsUUFBUSxFQUFFO1FBQ1o7TUFDRjtJQUNGLENBQUM7SUFDREUsUUFBUSxFQUFFLElBQUk7SUFDZEMsTUFBTSxFQUFFO0VBQ1YsQ0FBQyxDQUFDO0FBQ0o7QUFBQ0MsTUFBQSxDQUFBQyxPQUFBLEdBQUFBLE9BQUEsQ0FBQUMsT0FBQSJ9