"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = forecastFeature;
var _constants = require("../../utils/constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

function forecastFeature(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.forecast = components.clientAction.namespaceFactory();
  const forecast = Client.prototype.forecast.prototype;
  forecast.deleteForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  forecast.runOnceForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>/_run_once`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  forecast.createForecaster = ca({
    url: {
      fmt: _constants.API.FORECASTER_BASE
    },
    needBody: true,
    method: 'POST'
  });
  forecast.validateForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/_validate/<%=validationType%>`,
      req: {
        validationType: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  forecast.suggestForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/_suggest/<%=suggestType%>`,
      req: {
        suggestType: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  forecast.searchForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  forecast.searchTasks = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/tasks/_search`
    },
    needBody: true,
    method: 'POST'
  });
  forecast.updateForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  forecast.getForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>?job=true&task=true`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  forecast.searchResults = ca({
    url: {
      fmt: `/${_constants.DEFAULT_FORECAST_RESULT_INDEX_WILDCARD}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  forecast.searchResultsFromCustomResultIndex = ca({
    url: {
      fmt: `/<%=resultIndex%>/_search`,
      req: {
        resultIndex: {
          type: 'string',
          required: false
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  forecast.startForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>/_start`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  forecast.stopForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>/_stop`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  forecast.forecasterProfile = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>/_profile/init_progress,state,error`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  forecast.matchForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/match?name=<%=forecasterName%>`,
      req: {
        forecasterName: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'GET'
  });
  forecast.forecasterCount = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/count`
    },
    method: 'GET'
  });
  forecast.topForecastResults = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>/results/_topForecasts`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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