"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = alertingPlugin;
var _constants = require("../../utils/constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

function alertingPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.adAlerting = components.clientAction.namespaceFactory();
  const adAlerting = Client.prototype.adAlerting.prototype;
  adAlerting.searchMonitors = ca({
    url: {
      fmt: `${_constants.API.ALERTING_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  adAlerting.searchAlerts = ca({
    url: {
      fmt: `${_constants.API.ALERTING_BASE}/alerts?size=${_constants.MAX_ALERTS}&monitorId=<%=monitorId%>&sortString=start_time&sortOrder=desc&searchString=start_time:[<%=startTime%>%20TO%20<%=endTime%>]`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        },
        startTime: {
          type: 'number',
          required: true
        },
        endTime: {
          type: 'number',
          required: true
        }
      }
    },
    method: 'GET'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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