"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = adPlugin;
var _constants = require("../../utils/constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

function adPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.ad = components.clientAction.namespaceFactory();
  const ad = Client.prototype.ad.prototype;
  ad.deleteDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  ad.previewDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_preview`
    },
    needBody: true,
    method: 'POST'
  });
  ad.createDetector = ca({
    url: {
      fmt: _constants.API.DETECTOR_BASE
    },
    needBody: true,
    method: 'POST'
  });
  ad.validateDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_validate/<%=validationType%>`,
      req: {
        validationType: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ad.suggestDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_suggest/<%=suggestType%>`,
      req: {
        suggestType: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ad.searchDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  ad.searchTasks = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/tasks/_search`
    },
    needBody: true,
    method: 'POST'
  });
  ad.updateDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  ad.getDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>?job=true&task=true`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  ad.searchResults = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/results/_search`
    },
    needBody: true,
    method: 'POST'
  });
  ad.searchResultsFromCustomResultIndex = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/results/_search/<%=resultIndex%>?only_query_custom_result_index=<%=onlyQueryCustomResultIndex%>`,
      req: {
        resultIndex: {
          type: 'string',
          required: false
        },
        onlyQueryCustomResultIndex: {
          type: 'string',
          required: false
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ad.startDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_start`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  ad.startHistoricalDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_start`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
  ad.stopDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_stop`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  ad.stopHistoricalDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_stop?historical=true`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  ad.detectorProfile = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_profile/init_progress,state,error`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  ad.matchDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/match?name=<%=detectorName%>`,
      req: {
        detectorName: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'GET'
  });
  ad.detectorCount = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/count`
    },
    method: 'GET'
  });
  ad.topAnomalyResults = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/results/_topAnomalies?historical=false`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
  ad.topHistoricalAnomalyResults = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/results/_topAnomalies?historical=true`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
  ad.startInsights = ca({
    url: {
      fmt: `/_plugins/_anomaly_detection/insights/_start`
    },
    method: 'POST'
  });
  ad.stopInsights = ca({
    url: {
      fmt: `/_plugins/_anomaly_detection/insights/_stop`
    },
    method: 'POST'
  });
  ad.getInsightsStatus = ca({
    url: {
      fmt: `/_plugins/_anomaly_detection/insights/_status`
    },
    method: 'GET'
  });
  ad.getInsightsResults = ca({
    url: {
      fmt: `/_plugins/_anomaly_detection/insights/_results`
    },
    method: 'GET'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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