"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WRONG_THROTTLE_WARNING = exports.URL = exports.PLUGIN_NAME = exports.OPEN_SEARCH_PREFIX = exports.MONITORS_NAV_ID = exports.MAX_THROTTLE_VALUE = exports.INDEX_PREFIX = exports.INDEX = exports.DESTINATIONS_NAV_ID = exports.ALERTS_NAV_ID = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Keeping index prefix as 'opendistro' as migrating the system index is currently difficult to complete
const OPEN_SEARCH_PREFIX = exports.OPEN_SEARCH_PREFIX = 'opendistro';
const PLUGIN_NAME = exports.PLUGIN_NAME = `alerting`;
const INDEX_PREFIX = exports.INDEX_PREFIX = `${OPEN_SEARCH_PREFIX}-alerting`;
const INDEX = exports.INDEX = {
  SCHEDULED_JOBS: `.${INDEX_PREFIX}-config`,
  ALERTS: `.${INDEX_PREFIX}-alerts`,
  ALL_ALERTS: `.${INDEX_PREFIX}-alert*`,
  ALERT_HISTORY_WRITE: `.${INDEX_PREFIX}-alert-history-write`
};
const URL = exports.URL = {
  MUSTACHE: 'https://mustache.github.io/mustache.5.html',
  DOCUMENTATION: 'https://docs-beta.opensearch.org/monitoring-plugins/alerting/',
  CREATE_MONITOR_DOCUMENTATION: 'https://opensearch.org/docs/monitoring-plugins/alerting/monitors/#create-monitors'
};
const MAX_THROTTLE_VALUE = exports.MAX_THROTTLE_VALUE = 1440;
const WRONG_THROTTLE_WARNING = exports.WRONG_THROTTLE_WARNING = `Throttle value must be greater than 0 and less than ${MAX_THROTTLE_VALUE}.`;
const ALERTS_NAV_ID = exports.ALERTS_NAV_ID = `alerts`;
const DESTINATIONS_NAV_ID = exports.DESTINATIONS_NAV_ID = `destinations`;
const MONITORS_NAV_ID = exports.MONITORS_NAV_ID = `monitors`;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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