"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createValidateQuerySchema = createValidateQuerySchema;
exports.isIndexNotFoundError = void 0;
exports.mapKeysDeep = mapKeysDeep;
exports.toSnake = exports.toCamel = void 0;
var _lodash = require("lodash");
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function mapKeysDeep(obj, fn) {
  if (Array.isArray(obj)) {
    return (0, _lodash.map)(obj, innerObj => mapKeysDeep(innerObj, fn));
  } else {
    return (0, _lodash.isPlainObject)(obj) ? (0, _lodash.mapValues)((0, _lodash.mapKeys)(obj, fn), value => mapKeysDeep(value, fn)) : obj;
  }
}
const toSnake = (value, key) => (0, _lodash.snakeCase)(key);
exports.toSnake = toSnake;
const toCamel = (value, key) => (0, _lodash.camelCase)(key);
exports.toCamel = toCamel;
const isIndexNotFoundError = err => {
  return err.statusCode === 404 && (0, _lodash.get)(err, 'body.error.reason', '') === 'Configured indices are not found: [.opendistro-alerting-config]';
};
exports.isIndexNotFoundError = isIndexNotFoundError;
function createValidateQuerySchema(dataSourceEnabled, fields = {}) {
  // Extend the query schema with the specified fields
  const schemaObj = {
    ...fields
  };
  if (dataSourceEnabled) {
    schemaObj['dataSourceId'] = _configSchema.schema.string();
  }
  return _configSchema.schema.object(schemaObj);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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