"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WORKFLOW_BASE_API = exports.MONITOR_BASE_API = exports.EMAIL_GROUP_BASE_API = exports.EMAIL_ACCOUNT_BASE_API = exports.DESTINATION_BASE_API = exports.DEFAULT_HEADERS = exports.CROSS_CLUSTER_BASE_API = exports.COMMENTS_BASE_API = exports.CLUSTER = exports.API_ROUTE_PREFIX = exports.AD_BASE_API = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const API_ROUTE_PREFIX = exports.API_ROUTE_PREFIX = '/_plugins/_alerting';
const MONITOR_BASE_API = exports.MONITOR_BASE_API = `${API_ROUTE_PREFIX}/monitors`;
const COMMENTS_BASE_API = exports.COMMENTS_BASE_API = `${API_ROUTE_PREFIX}/comments`;
const WORKFLOW_BASE_API = exports.WORKFLOW_BASE_API = `${API_ROUTE_PREFIX}/workflows`;
const CROSS_CLUSTER_BASE_API = exports.CROSS_CLUSTER_BASE_API = `${API_ROUTE_PREFIX}/remote`;
const AD_BASE_API = exports.AD_BASE_API = `/_plugins/_anomaly_detection/detectors`;
const DESTINATION_BASE_API = exports.DESTINATION_BASE_API = `${API_ROUTE_PREFIX}/destinations`;
const EMAIL_ACCOUNT_BASE_API = exports.EMAIL_ACCOUNT_BASE_API = `${DESTINATION_BASE_API}/email_accounts`;
const EMAIL_GROUP_BASE_API = exports.EMAIL_GROUP_BASE_API = `${DESTINATION_BASE_API}/email_groups`;
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json',
  'User-Agent': 'OpenSearch-Dashboards'
};
const CLUSTER = exports.CLUSTER = {
  ADMIN: 'admin',
  ALERTING: 'opensearch_alerting',
  AD_ALERTING: 'alerting_ad',
  DATA: 'data'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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