"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.anomalyResultMapper = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const anomalyResultMapper = anomalyResults => {
  let resultData = {
    anomalies: [],
    featureData: {}
  };
  if (anomalyResults.length === 0) return resultData;
  //initialize features list.
  const firstAnomaly = anomalyResults[0];
  Object.values(firstAnomaly.featureData).forEach(feature => {
    resultData.featureData[feature.featureId] = [];
  });
  anomalyResults.forEach(({
    featureData,
    ...rest
  }) => {
    resultData.anomalies.push({
      ...rest,
      anomalyGrade: rest.anomalyGrade != null && rest.anomalyGrade > 0 ? Number.parseFloat(rest.anomalyGrade).toFixed(2) : 0,
      confidence: rest.confidence != null && rest.confidence > 0 ? Number.parseFloat(rest.confidence).toFixed(2) : 0,
      plotTime: rest.dataStartTime + Math.floor((rest.dataEndTime - rest.dataStartTime) / 2)
    });
    featureData.forEach(feature => {
      resultData.featureData[feature.featureId].push({
        startTime: rest.dataStartTime,
        endTime: rest.dataEndTime,
        plotTime: rest.dataStartTime + Math.floor((rest.dataEndTime - rest.dataStartTime) / 2),
        data: feature.data
      });
    });
  });
  return resultData;
};
exports.anomalyResultMapper = anomalyResultMapper;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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