"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _http = require("http");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class OpensearchService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    // TODO: This will be deprecated as we do not want to support accessing alerting indices directly
    //  and that is what this is used for
    _defineProperty(this, "search", async (context, req, res) => {
      try {
        const {
          query,
          index,
          size
        } = req.body;
        const params = {
          index,
          size,
          body: query
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const results = await client('search', params);
        return res.ok({
          body: {
            ok: true,
            resp: results
          }
        });
      } catch (err) {
        console.error('Alerting - OpensearchService - search', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getIndices", async (context, req, res) => {
      try {
        const {
          index
        } = req.body;
        const client = this.getClientBasedOnDataSource(context, req);
        const indices = await client('cat.indices', {
          index,
          format: 'json',
          h: 'health,index,status'
        });
        return res.ok({
          body: {
            ok: true,
            resp: indices
          }
        });
      } catch (err) {
        // Opensearch throws an index_not_found_exception which we'll treat as a success
        if (err.statusCode === 404) {
          return res.ok({
            body: {
              ok: true,
              resp: []
            }
          });
        } else {
          console.error('Alerting - OpensearchService - getIndices:', err);
          return res.ok({
            body: {
              ok: false,
              resp: err.message
            }
          });
        }
      }
    });
    _defineProperty(this, "getAliases", async (context, req, res) => {
      try {
        const {
          alias
        } = req.body;
        const client = this.getClientBasedOnDataSource(context, req);
        const aliases = await client('cat.aliases', {
          alias,
          format: 'json',
          h: 'alias,index'
        });
        return res.ok({
          body: {
            ok: true,
            resp: aliases
          }
        });
      } catch (err) {
        console.error('Alerting - OpensearchService - getAliases:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getClusterHealth", async (context, req, res) => {
      try {
        const client = this.getClientBasedOnDataSource(context, req);
        const health = await client('cat.health', {
          format: 'json',
          h: 'cluster,status'
        });
        return res.ok({
          body: {
            ok: true,
            resp: health
          }
        });
      } catch (err) {
        console.error('Alerting - OpensearchService - getClusterHealth:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getMappings", async (context, req, res) => {
      try {
        const {
          index
        } = req.body;
        const client = this.getClientBasedOnDataSource(context, req);
        const mappings = await client('indices.getMapping', {
          index
        });
        return res.ok({
          body: {
            ok: true,
            resp: mappings
          }
        });
      } catch (err) {
        console.error('Alerting - OpensearchService - getMappings:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getPlugins", async (context, req, res) => {
      try {
        const client = this.getClientBasedOnDataSource(context, req);
        const plugins = await client('cat.plugins', {
          format: 'json',
          h: 'component'
        });
        return res.ok({
          body: {
            ok: true,
            resp: plugins
          }
        });
      } catch (err) {
        console.error('Alerting - OpensearchService - getPlugins:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getSettings", async (context, req, res) => {
      try {
        const client = this.getClientBasedOnDataSource(context, req);
        const settings = await client('cluster.getSettings', {
          include_defaults: 'true'
        });
        return res.ok({
          body: {
            ok: true,
            resp: settings
          }
        });
      } catch (err) {
        console.error('Alerting - OpensearchService - getSettings:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
  }
}
exports.default = OpensearchService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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