"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MDSEnabledClientService = void 0;
class MDSEnabledClientService {
  constructor(osDriver, dataSourceEnabled) {
    this.osDriver = osDriver;
    this.dataSourceEnabled = dataSourceEnabled;
  }
  getClientBasedOnDataSource(context, request) {
    const dataSourceId = request.query.dataSourceId;
    return this.dataSourceEnabled && dataSourceId ? context.dataSource.opensearch.legacy.getClient(dataSourceId.toString()).callAPI : this.osDriver.asScoped(request).callAsCurrentUser;
  }
}
exports.MDSEnabledClientService = MDSEnabledClientService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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