"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GET_FINDINGS_SORT_FIELDS = exports.DEFAULT_GET_FINDINGS_PARAMS = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
// TODO DRAFT: Are these sortField options appropriate?
const GET_FINDINGS_SORT_FIELDS = exports.GET_FINDINGS_SORT_FIELDS = {
  INDEX: 'index',
  MONITOR_NAME: 'monitor_name',
  TIMESTAMP: 'timestamp'
};

// TODO DRAFT: RestGetFindingsAction.kt in the backend references a `missing` field in params.
//  Investigate if/how we should make use of that.
const DEFAULT_GET_FINDINGS_PARAMS = exports.DEFAULT_GET_FINDINGS_PARAMS = {
  // TODO DRAFT: Does providing a finding ID serve a particular function? Results with/without the ID seemed the same.
  id: undefined,
  from: 0,
  search: '',
  size: 20,
  sortDirection: 'desc',
  sortField: GET_FINDINGS_SORT_FIELDS.TIMESTAMP
};
class FindingService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getFindings", async (context, req, res) => {
      const {
        id = DEFAULT_GET_FINDINGS_PARAMS.id,
        from = DEFAULT_GET_FINDINGS_PARAMS.from,
        size = DEFAULT_GET_FINDINGS_PARAMS.size,
        search = DEFAULT_GET_FINDINGS_PARAMS.search,
        sortDirection = DEFAULT_GET_FINDINGS_PARAMS.sortDirection,
        sortField = DEFAULT_GET_FINDINGS_PARAMS.sortField
      } = req.query;
      var params;
      switch (sortField) {
        case GET_FINDINGS_SORT_FIELDS.INDEX:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;
        case GET_FINDINGS_SORT_FIELDS.MONITOR_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;
        default:
          // If the sortField parsed from the URL isn't a valid option for this API, use a default option.
          params = {
            sortString: GET_FINDINGS_SORT_FIELDS.TIMESTAMP,
            sortOrder: sortDirection
          };
      }
      if (!_lodash.default.isEmpty(id)) params.findingId = id;
      params.startIndex = from;
      params.size = size;
      params.searchString = search;
      if (search.trim()) params.searchString = `*${search.trim().split(' ').join('* *')}*`;
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.getFindings', params);
        const findings = resp.findings.map(result => ({
          [result.finding.id]: {
            ...result
          }
        }));
        const totalFindings = resp.totalFindings;
        return res.ok({
          body: {
            ok: true,
            findings,
            totalFindings
          }
        });
      } catch (err) {
        console.log(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
  }
}
exports.default = FindingService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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