"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _helpers = require("./utils/helpers");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class DestinationsService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "createDestination", async (context, req, res) => {
      try {
        const params = {
          body: req.body
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const createResponse = await client('alerting.createDestination', params);
        return res.ok({
          body: {
            ok: true,
            resp: createResponse
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - createDestination:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "updateDestination", async (context, req, res) => {
      try {
        const {
          destinationId
        } = req.params;
        const {
          ifSeqNo,
          ifPrimaryTerm
        } = req.query;
        const params = {
          body: req.body,
          destinationId,
          ifSeqNo,
          ifPrimaryTerm
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const updateResponse = await client('alerting.updateDestination', params);
        const {
          _version,
          _id
        } = updateResponse;
        return res.ok({
          body: {
            ok: true,
            version: _version,
            id: _id
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - updateDestination:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "deleteDestination", async (context, req, res) => {
      try {
        const {
          destinationId
        } = req.params;
        const params = {
          destinationId
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const response = await client('alerting.deleteDestination', params);
        return res.ok({
          body: {
            ok: response.result === 'deleted'
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - deleteDestination:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getDestination", async (context, req, res) => {
      const {
        destinationId
      } = req.params;
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const params = {
          destinationId
        };
        const resp = await client('alerting.getDestination', params);
        const destination = resp.destinations[0];
        const version = destination.schema_version;
        const ifSeqNo = destination.seq_no;
        const ifPrimaryTerm = destination.primary_term;
        return res.ok({
          body: {
            ok: true,
            destination,
            version,
            ifSeqNo,
            ifPrimaryTerm
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - getDestination:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getDestinations", async (context, req, res) => {
      const client = this.getClientBasedOnDataSource(context, req);
      const {
        from = 0,
        size = 20,
        search = '',
        sortDirection = 'desc',
        sortField = 'start_time',
        type = 'ALL'
      } = req.query;
      var params;
      switch (sortField) {
        case 'name':
          params = {
            sortString: 'destination.name.keyword',
            sortOrder: sortDirection
          };
          break;
        case 'type':
          params = {
            sortString: 'destination.type',
            sortOrder: sortDirection
          };
          break;
        default:
          params = {};
          break;
      }
      params.startIndex = from;
      params.size = size;
      params.searchString = search;
      if (search.trim()) params.searchString = `*${search.trim().split(' ').join('* *')}*`;
      params.destinationType = type;
      try {
        const resp = await client('alerting.searchDestinations', params);
        const destinations = resp.destinations.map(hit => {
          const destination = hit;
          const id = destination.id;
          const version = destination.schema_version;
          const ifSeqNo = destination.seq_no;
          const ifPrimaryTerm = destination.primary_term;
          return {
            id,
            ...destination,
            version,
            ifSeqNo,
            ifPrimaryTerm
          };
        });
        const totalDestinations = resp.totalDestinations;
        return res.ok({
          body: {
            ok: true,
            destinations,
            totalDestinations
          }
        });
      } catch (err) {
        // Indices will be created when the monitor is created.
        if ((0, _helpers.isIndexNotFoundError)(err)) {
          return res.ok({
            body: {
              ok: false,
              totalMonitors: 0,
              monitors: [],
              message: "Config index will be created automatically when the monitor is created"
            }
          });
        } else {
          return res.ok({
            body: {
              ok: false,
              err: err.message
            }
          });
        }
      }
    });
    /**
     *  -----------------------------------------------------
     *  ----------------- Email Account API -----------------
     *  -----------------------------------------------------
     */
    _defineProperty(this, "createEmailAccount", async (context, req, res) => {
      try {
        const params = {
          body: req.body
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const createResponse = await client('alerting.createEmailAccount', params);
        return res.ok({
          body: {
            ok: true,
            resp: createResponse
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - createEmailAccount:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "updateEmailAccount", async (context, req, res) => {
      try {
        const {
          id
        } = req.params;
        const {
          ifSeqNo,
          ifPrimaryTerm
        } = req.query;
        const params = {
          emailAccountId: id,
          ifSeqNo,
          ifPrimaryTerm,
          body: req.body
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const updateResponse = await client('alerting.updateEmailAccount', params);
        const {
          _id
        } = updateResponse;
        return res.ok({
          body: {
            ok: true,
            id: _id
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - updateEmailAccount:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "deleteEmailAccount", async (context, req, res) => {
      try {
        const {
          id
        } = req.params;
        const params = {
          emailAccountId: id
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const deleteResponse = await client('alerting.deleteEmailAccount', params);
        return res.ok({
          body: {
            ok: deleteResponse.result === 'deleted'
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - deleteEmailAccount:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getEmailAccount", async (context, req, res) => {
      try {
        const {
          id
        } = req.params;
        const params = {
          emailAccountId: id
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const getResponse = await client('alerting.getEmailAccount', params);
        const emailAccount = _lodash.default.get(getResponse, 'email_account', null);
        const ifSeqNo = _lodash.default.get(getResponse, '_seq_no', null);
        const ifPrimaryTerm = _lodash.default.get(getResponse, '_primary_term', null);
        if (emailAccount) {
          return res.ok({
            body: {
              ok: true,
              resp: emailAccount,
              ifSeqNo,
              ifPrimaryTerm
            }
          });
        } else {
          return res.ok({
            body: {
              ok: false
            }
          });
        }
      } catch (err) {
        console.error('Alerting - DestinationService - getEmailAccount:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getEmailAccounts", async (context, req, res) => {
      try {
        const {
          from = 0,
          size = 20,
          search = '',
          sortDirection = 'desc',
          sortField = 'name'
        } = req.query;
        let must = {
          match_all: {}
        };
        if (search.trim()) {
          must = {
            query_string: {
              default_field: 'email_account.name',
              default_operator: 'AND',
              query: `*${search.trim().split(' ').join('* *')}*`
            }
          };
        }
        const sortQueryMap = {
          name: {
            'email_account.name.keyword': sortDirection
          }
        };
        let sort = [];
        const sortQuery = sortQueryMap[sortField];
        if (sortQuery) sort = sortQuery;
        const params = {
          body: {
            from,
            size,
            sort,
            query: {
              bool: {
                must
              }
            }
          }
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const getResponse = await client('alerting.getEmailAccounts', params);
        const totalEmailAccounts = _lodash.default.get(getResponse, 'hits.total.value', 0);
        const emailAccounts = _lodash.default.get(getResponse, 'hits.hits', []).map(result => {
          const {
            _id: id,
            _seq_no: ifSeqNo,
            _primary_term: ifPrimaryTerm,
            _source: emailAccount
          } = result;
          return {
            id,
            ...emailAccount,
            ifSeqNo,
            ifPrimaryTerm
          };
        });
        return res.ok({
          body: {
            ok: true,
            emailAccounts,
            totalEmailAccounts
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - getEmailAccounts:', err);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    /**
     *  -----------------------------------------------------
     *  ----------------- Email Group API -------------------
     *  -----------------------------------------------------
     */
    _defineProperty(this, "createEmailGroup", async (context, req, res) => {
      try {
        const params = {
          body: req.body
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const createResponse = await client('alerting.createEmailGroup', params);
        return res.ok({
          body: {
            ok: true,
            resp: createResponse
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - createEmailGroup:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "updateEmailGroup", async (context, req, res) => {
      try {
        const {
          id
        } = req.params;
        const {
          ifSeqNo,
          ifPrimaryTerm
        } = req.query;
        const params = {
          emailGroupId: id,
          ifSeqNo,
          ifPrimaryTerm,
          body: req.body
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const updateResponse = await client('alerting.updateEmailGroup', params);
        const {
          _id
        } = updateResponse;
        return res.ok({
          body: {
            ok: true,
            id: _id
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - updateEmailGroup:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "deleteEmailGroup", async (context, req, res) => {
      try {
        const {
          id
        } = req.params;
        const params = {
          emailGroupId: id
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const deleteResponse = await client('alerting.deleteEmailGroup', params);
        return res.ok({
          body: {
            ok: deleteResponse.result === 'deleted'
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - deleteEmailGroup:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getEmailGroup", async (context, req, res) => {
      try {
        const {
          id
        } = req.params;
        const params = {
          emailGroupId: id
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const getResponse = await client('alerting.getEmailGroup', params);
        const emailGroup = _lodash.default.get(getResponse, 'email_group', null);
        const ifSeqNo = _lodash.default.get(getResponse, '_seq_no', null);
        const ifPrimaryTerm = _lodash.default.get(getResponse, '_primary_term', null);
        if (emailGroup) {
          return res.ok({
            body: {
              ok: true,
              resp: emailGroup,
              ifSeqNo,
              ifPrimaryTerm
            }
          });
        } else {
          return res.ok({
            body: {
              ok: false
            }
          });
        }
      } catch (err) {
        console.error('Alerting - DestinationService - getEmailGroup:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getEmailGroups", async (context, req, res) => {
      try {
        const {
          from = 0,
          size = 20,
          search = '',
          sortDirection = 'desc',
          sortField = 'name'
        } = req.query;
        let must = {
          match_all: {}
        };
        if (search.trim()) {
          must = {
            query_string: {
              default_field: 'email_group.name',
              default_operator: 'AND',
              query: `*${search.trim().split(' ').join('* *')}*`
            }
          };
        }
        const sortQueryMap = {
          name: {
            'email_group.name.keyword': sortDirection
          }
        };
        let sort = [];
        const sortQuery = sortQueryMap[sortField];
        if (sortQuery) sort = sortQuery;
        const params = {
          body: {
            from,
            size,
            sort,
            query: {
              bool: {
                must
              }
            }
          }
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const getResponse = await client('alerting.getEmailGroups', params);
        const totalEmailGroups = _lodash.default.get(getResponse, 'hits.total.value', 0);
        const emailGroups = _lodash.default.get(getResponse, 'hits.hits', []).map(result => {
          const {
            _id: id,
            _seq_no: ifSeqNo,
            _primary_term: ifPrimaryTerm,
            _source: emailGroup
          } = result;
          return {
            id,
            ...emailGroup,
            ifSeqNo,
            ifPrimaryTerm
          };
        });
        return res.ok({
          body: {
            ok: true,
            emailGroups,
            totalEmailGroups
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - getEmailGroups:', err);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
  }
}
exports.default = DestinationsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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