"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = require("lodash");
var _helpers = require("./utils/helpers");
var _adHelpers = require("./utils/adHelpers");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
const MAX_DETECTOR_COUNT = 1000;
class DestinationsService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getDetector", async (context, req, res) => {
      const {
        detectorId
      } = req.params;
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alertingAD.getDetector', {
          detectorId
        });
        const {
          anomaly_detector,
          _seq_no: seqNo,
          _primary_term: primaryTerm,
          _version: version
        } = resp;
        return res.ok({
          body: {
            ok: true,
            detector: anomaly_detector,
            version,
            seqNo,
            primaryTerm
          }
        });
      } catch (err) {
        console.error('Alerting - AnomalyDetectorService - getDetector:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getDetectors", async (context, req, res) => {
      const searchRequest = {
        query: {
          bool: {}
        },
        size: MAX_DETECTOR_COUNT
      };
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alertingAD.searchDetectors', {
          body: searchRequest
        });
        const totalDetectors = resp.hits.total.value;
        const detectors = resp.hits.hits.map(hit => {
          const {
            _source: detector,
            _id: id,
            _version: version,
            _seq_no: seqNo,
            _primary_term: primaryTerm
          } = hit;
          return {
            id,
            ...detector,
            version,
            seqNo,
            primaryTerm
          };
        });
        return res.ok({
          body: {
            ok: true,
            detectors: (0, _helpers.mapKeysDeep)(detectors, _helpers.toCamel),
            totalDetectors
          }
        });
      } catch (err) {
        console.error('Alerting - AnomalyDetectorService - searchDetectors:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getDetectorResults", async (context, req, res) => {
      try {
        const {
          startTime = 0,
          endTime = 20,
          preview = 'false'
        } = req.query;
        const {
          detectorId
        } = req.params;
        const client = this.getClientBasedOnDataSource(context, req);
        if (preview == 'true') {
          const requestBody = {
            period_start: startTime,
            period_end: endTime
          };
          const previewResponse = await client('alertingAD.previewDetector', {
            detectorId,
            body: requestBody
          });
          const transformedKeys = (0, _helpers.mapKeysDeep)(previewResponse, _helpers.toCamel);
          return res.ok({
            body: {
              ok: true,
              response: {
                anomalyResult: (0, _adHelpers.anomalyResultMapper)(transformedKeys.anomalyResult),
                detector: transformedKeys.anomalyDetector
              }
            }
          });
        } else {
          //Get results
          const requestBody = {
            size: 10000,
            sort: {
              data_start_time: 'asc'
            },
            query: {
              bool: {
                filter: [{
                  term: {
                    detector_id: detectorId
                  }
                }, {
                  range: {
                    data_start_time: {
                      gte: startTime,
                      lte: endTime
                    }
                  }
                }]
              }
            }
          };
          const detectorResponse = await client('alertingAD.getDetector', {
            detectorId
          });
          const anomaliesResponse = await client('alertingAD.searchResults', {
            body: requestBody
          });
          const transformedKeys = (0, _lodash.get)(anomaliesResponse, 'hits.hits', []).map(result => (0, _helpers.mapKeysDeep)(result._source, _helpers.toCamel));
          return res.ok({
            body: {
              ok: true,
              response: {
                detector: (0, _helpers.mapKeysDeep)((0, _lodash.get)(detectorResponse, 'anomaly_detector', {}), _helpers.toCamel),
                anomalyResult: (0, _adHelpers.anomalyResultMapper)(transformedKeys)
              }
            }
          });
        }
      } catch (err) {
        console.log('Alerting - AnomalyDetectorService - getDetectorResults', err);
        return res.ok({
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = DestinationsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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