"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GET_ALERTS_SORT_FILTERS = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
const GET_ALERTS_SORT_FILTERS = exports.GET_ALERTS_SORT_FILTERS = {
  MONITOR_NAME: 'monitor_name',
  TRIGGER_NAME: 'trigger_name',
  START_TIME: 'start_time',
  END_TIME: 'end_time',
  ACKNOWLEDGE_TIME: 'acknowledged_time'
};
class AlertService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getAlerts", async (context, req, res) => {
      const {
        from = 0,
        size = 20,
        search = '',
        sortDirection = 'desc',
        sortField = GET_ALERTS_SORT_FILTERS.START_TIME,
        severityLevel = 'ALL',
        alertState = 'ALL',
        monitorIds = [],
        monitorType = 'monitor'
      } = req.query;
      var params;
      switch (sortField) {
        case GET_ALERTS_SORT_FILTERS.MONITOR_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;
        case GET_ALERTS_SORT_FILTERS.TRIGGER_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;
        case GET_ALERTS_SORT_FILTERS.END_TIME:
          params = {
            sortString: sortField,
            sortOrder: sortDirection,
            missing: sortDirection === 'asc' ? '_last' : '_first'
          };
          break;
        case GET_ALERTS_SORT_FILTERS.ACKNOWLEDGE_TIME:
          params = {
            sortString: sortField,
            sortOrder: sortDirection,
            missing: '_last'
          };
          break;
        default:
          // If the sortField parsed from the URL isn't a valid option for this API, use a default option.
          params = {
            sortString: GET_ALERTS_SORT_FILTERS.START_TIME,
            sortOrder: sortDirection
          };
      }
      params.startIndex = from;
      params.size = size;
      params.severityLevel = severityLevel;
      params.alertState = alertState;
      params.searchString = search;
      if (search.trim()) params.searchString = `*${search.trim().split(' ').join('* *')}*`;
      if (monitorIds.length > 0) {
        const idField = monitorType === 'composite' ? 'workflowIds' : 'monitorId';
        params[idField] = !Array.isArray(monitorIds) ? monitorIds : monitorIds[0];
      }
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.getAlerts', params);
        const alerts = resp.alerts.map(hit => {
          const alert = hit;
          const id = hit.alert_id;
          const version = hit.alert_version;
          return {
            id,
            ...alert,
            version,
            alert_source: !!alert.workflow_id ? 'workflow' : 'monitor'
          };
        });
        const totalAlerts = resp.totalAlerts;
        return res.ok({
          body: {
            ok: true,
            alerts,
            totalAlerts
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    _defineProperty(this, "getWorkflowAlerts", async (context, req, res) => {
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.getWorkflowAlerts', req.query);
        return res.ok({
          body: {
            ok: true,
            resp
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
  }
}
exports.default = AlertService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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