"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    opensearchService
  } = services;
  router.post({
    path: '/api/alerting/_search',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, opensearchService.search);
  router.post({
    path: '/api/alerting/_indices',
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, opensearchService.getIndices);
  router.post({
    path: '/api/alerting/_aliases',
    validate: {
      body: _configSchema.schema.object({
        alias: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, opensearchService.getAliases);
  router.post({
    path: '/api/alerting/_mappings',
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.arrayOf(_configSchema.schema.string())
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, opensearchService.getMappings);
  router.get({
    path: '/api/alerting/_plugins',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, opensearchService.getPlugins);
  router.get({
    path: '/api/alerting/_settings',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, opensearchService.getSettings);
  router.get({
    path: '/api/alerting/_health',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, opensearchService.getClusterHealth);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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