"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    monitorService
  } = services;
  const fieldValidations = {
    from: _configSchema.schema.number(),
    size: _configSchema.schema.number(),
    search: _configSchema.schema.string(),
    sortField: _configSchema.schema.string(),
    sortDirection: _configSchema.schema.string(),
    state: _configSchema.schema.string(),
    monitorIds: _configSchema.schema.maybe(_configSchema.schema.any())
  };
  router.get({
    path: '/api/alerting/monitors',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidations)
    }
  }, monitorService.getMonitors);
  router.post({
    path: '/api/alerting/monitors/_search',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.searchMonitors);
  router.post({
    path: '/api/alerting/monitors',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.createMonitor);
  router.post({
    path: '/api/alerting/workflows',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.createWorkflow);
  router.post({
    path: '/api/alerting/monitors/_execute',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, {
        dryrun: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, monitorService.executeMonitor);
  router.get({
    path: '/api/alerting/workflows/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.getWorkflow);
  router.get({
    path: '/api/alerting/monitors/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.getMonitor);
  const fieldValidationForMonitors = {
    ifSeqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
    ifPrimaryTerm: _configSchema.schema.maybe(_configSchema.schema.number())
  };
  router.put({
    path: '/api/alerting/monitors/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidationForMonitors)
    }
  }, monitorService.updateMonitor);
  router.put({
    path: '/api/alerting/workflows/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidationForMonitors),
      body: _configSchema.schema.any()
    }
  }, monitorService.updateMonitor);
  router.delete({
    path: '/api/alerting/monitors/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, {
        version: _configSchema.schema.number()
      })
    }
  }, monitorService.deleteMonitor);
  router.delete({
    path: '/api/alerting/workflows/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, {
        version: _configSchema.schema.number()
      })
    }
  }, monitorService.deleteWorkflow);
  router.post({
    path: '/api/alerting/monitors/{id}/_acknowledge/alerts',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.acknowledgeAlerts);
  router.post({
    path: '/api/alerting/workflows/{id}/_acknowledge/alerts',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.acknowledgeChainedAlerts);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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