"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    findingService
  } = services;
  const fieldValidations = {
    id: _configSchema.schema.maybe(_configSchema.schema.string()),
    from: _configSchema.schema.number(),
    size: _configSchema.schema.number(),
    search: _configSchema.schema.string(),
    sortField: _configSchema.schema.string(),
    sortDirection: _configSchema.schema.string()
  };
  router.get({
    path: '/api/alerting/findings/_search',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidations)
    }
  }, findingService.getFindings);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9oZWxwZXJzIiwiX2RlZmF1bHQiLCJzZXJ2aWNlcyIsInJvdXRlciIsImRhdGFTb3VyY2VFbmFibGVkIiwiZmluZGluZ1NlcnZpY2UiLCJmaWVsZFZhbGlkYXRpb25zIiwiaWQiLCJzY2hlbWEiLCJtYXliZSIsInN0cmluZyIsImZyb20iLCJudW1iZXIiLCJzaXplIiwic2VhcmNoIiwic29ydEZpZWxkIiwic29ydERpcmVjdGlvbiIsImdldCIsInBhdGgiLCJ2YWxpZGF0ZSIsInF1ZXJ5IiwiY3JlYXRlVmFsaWRhdGVRdWVyeVNjaGVtYSIsImdldEZpbmRpbmdzIiwibW9kdWxlIiwiZXhwb3J0cyIsImRlZmF1bHQiXSwic291cmNlcyI6WyJmaW5kaW5ncy5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxyXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcclxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcclxuICovXHJcblxyXG5pbXBvcnQgeyBzY2hlbWEgfSBmcm9tICdAb3NkL2NvbmZpZy1zY2hlbWEnO1xyXG5pbXBvcnQgeyBjcmVhdGVWYWxpZGF0ZVF1ZXJ5U2NoZW1hIH0gZnJvbSAnLi4vc2VydmljZXMvdXRpbHMvaGVscGVycyc7XHJcblxyXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAoc2VydmljZXMsIHJvdXRlciwgZGF0YVNvdXJjZUVuYWJsZWQpIHtcclxuICBjb25zdCB7IGZpbmRpbmdTZXJ2aWNlIH0gPSBzZXJ2aWNlcztcclxuXHJcbiAgY29uc3QgZmllbGRWYWxpZGF0aW9ucyA9IHtcclxuICAgIGlkOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZygpKSxcclxuICAgIGZyb206IHNjaGVtYS5udW1iZXIoKSxcclxuICAgIHNpemU6IHNjaGVtYS5udW1iZXIoKSxcclxuICAgIHNlYXJjaDogc2NoZW1hLnN0cmluZygpLFxyXG4gICAgc29ydEZpZWxkOiBzY2hlbWEuc3RyaW5nKCksXHJcbiAgICBzb3J0RGlyZWN0aW9uOiBzY2hlbWEuc3RyaW5nKCksXHJcbiAgfTtcclxuICByb3V0ZXIuZ2V0KFxyXG4gICAge1xyXG4gICAgICBwYXRoOiAnL2FwaS9hbGVydGluZy9maW5kaW5ncy9fc2VhcmNoJyxcclxuICAgICAgdmFsaWRhdGU6IHtcclxuICAgICAgICBxdWVyeTogY3JlYXRlVmFsaWRhdGVRdWVyeVNjaGVtYShkYXRhU291cmNlRW5hYmxlZCwgZmllbGRWYWxpZGF0aW9ucyksXHJcbiAgICAgIH0sXHJcbiAgICB9LFxyXG4gICAgZmluZGluZ1NlcnZpY2UuZ2V0RmluZGluZ3NcclxuICApO1xyXG59XHJcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBS0EsSUFBQUEsYUFBQSxHQUFBQyxPQUFBO0FBQ0EsSUFBQUMsUUFBQSxHQUFBRCxPQUFBO0FBTkE7QUFDQTtBQUNBO0FBQ0E7O0FBS2UsU0FBQUUsU0FBVUMsUUFBUSxFQUFFQyxNQUFNLEVBQUVDLGlCQUFpQixFQUFFO0VBQzVELE1BQU07SUFBRUM7RUFBZSxDQUFDLEdBQUdILFFBQVE7RUFFbkMsTUFBTUksZ0JBQWdCLEdBQUc7SUFDdkJDLEVBQUUsRUFBRUMsb0JBQU0sQ0FBQ0MsS0FBSyxDQUFDRCxvQkFBTSxDQUFDRSxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ2pDQyxJQUFJLEVBQUVILG9CQUFNLENBQUNJLE1BQU0sQ0FBQyxDQUFDO0lBQ3JCQyxJQUFJLEVBQUVMLG9CQUFNLENBQUNJLE1BQU0sQ0FBQyxDQUFDO0lBQ3JCRSxNQUFNLEVBQUVOLG9CQUFNLENBQUNFLE1BQU0sQ0FBQyxDQUFDO0lBQ3ZCSyxTQUFTLEVBQUVQLG9CQUFNLENBQUNFLE1BQU0sQ0FBQyxDQUFDO0lBQzFCTSxhQUFhLEVBQUVSLG9CQUFNLENBQUNFLE1BQU0sQ0FBQztFQUMvQixDQUFDO0VBQ0RQLE1BQU0sQ0FBQ2MsR0FBRyxDQUNSO0lBQ0VDLElBQUksRUFBRSxnQ0FBZ0M7SUFDdENDLFFBQVEsRUFBRTtNQUNSQyxLQUFLLEVBQUUsSUFBQUMsa0NBQXlCLEVBQUNqQixpQkFBaUIsRUFBRUUsZ0JBQWdCO0lBQ3RFO0VBQ0YsQ0FBQyxFQUNERCxjQUFjLENBQUNpQixXQUNqQixDQUFDO0FBQ0g7QUFBQ0MsTUFBQSxDQUFBQyxPQUFBLEdBQUFBLE9BQUEsQ0FBQUMsT0FBQSJ9