"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    destinationsService
  } = services;
  const fieldValidations = {
    from: _configSchema.schema.maybe(_configSchema.schema.number()),
    size: _configSchema.schema.maybe(_configSchema.schema.number()),
    search: _configSchema.schema.maybe(_configSchema.schema.string()),
    sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
    sortDirection: _configSchema.schema.maybe(_configSchema.schema.string()),
    type: _configSchema.schema.maybe(_configSchema.schema.string())
  };
  router.get({
    path: '/api/alerting/destinations',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidations)
    }
  }, destinationsService.getDestinations);
  router.get({
    path: '/api/alerting/destinations/{destinationId}',
    validate: {
      params: _configSchema.schema.object({
        destinationId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.getDestination);
  router.post({
    path: '/api/alerting/destinations',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.createDestination);
  const destinationsFieldValidation = {
    ifSeqNo: _configSchema.schema.string(),
    ifPrimaryTerm: _configSchema.schema.string()
  };
  router.put({
    path: '/api/alerting/destinations/{destinationId}',
    validate: {
      params: _configSchema.schema.object({
        destinationId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, destinationsFieldValidation),
      body: _configSchema.schema.any()
    }
  }, destinationsService.updateDestination);
  router.delete({
    path: '/api/alerting/destinations/{destinationId}',
    validate: {
      params: _configSchema.schema.object({
        destinationId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.deleteDestination);
  const queryValidationFields = {
    search: _configSchema.schema.maybe(_configSchema.schema.string()),
    size: _configSchema.schema.number()
  };
  router.get({
    path: '/api/alerting/destinations/email_accounts',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, queryValidationFields)
    }
  }, destinationsService.getEmailAccounts);
  router.post({
    path: '/api/alerting/destinations/email_accounts',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, queryValidationFields)
    }
  }, destinationsService.createEmailAccount);
  router.get({
    path: '/api/alerting/destinations/email_accounts/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, queryValidationFields)
    }
  }, destinationsService.getEmailAccount);
  router.put({
    path: '/api/alerting/destinations/email_accounts/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, destinationsFieldValidation),
      body: _configSchema.schema.any()
    }
  }, destinationsService.updateEmailAccount);
  router.delete({
    path: '/api/alerting/destinations/email_accounts/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.deleteEmailAccount);
  router.get({
    path: '/api/alerting/destinations/email_groups',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, queryValidationFields)
    }
  }, destinationsService.getEmailGroups);
  router.post({
    path: '/api/alerting/destinations/email_groups',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.createEmailGroup);
  router.get({
    path: '/api/alerting/destinations/email_groups/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.getEmailGroup);
  router.put({
    path: '/api/alerting/destinations/email_groups/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, destinationsFieldValidation),
      body: _configSchema.schema.any()
    }
  }, destinationsService.updateEmailGroup);
  router.delete({
    path: '/api/alerting/destinations/email_groups/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.deleteEmailGroup);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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