"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    crossClusterService
  } = services;
  const fieldValidations = {
    indexes: _configSchema.schema.string(),
    include_mappings: _configSchema.schema.maybe(_configSchema.schema.boolean())
  };
  router.get({
    path: '/api/alerting/remote/indexes',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidations)
    }
  }, crossClusterService.getRemoteIndexes);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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