"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    commentsService
  } = services;
  router.post({
    path: '/api/alerting/comments/_search',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, commentsService.searchComments);
  router.post({
    path: '/api/alerting/comments/{alertId}',
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        alertId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, commentsService.createComment);
  router.put({
    path: '/api/alerting/comments/{commentId}',
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        commentId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, commentsService.updateComment);
  router.delete({
    path: '/api/alerting/comments/{commentId}',
    validate: {
      params: _configSchema.schema.object({
        commentId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, commentsService.deleteComment);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9oZWxwZXJzIiwiX2RlZmF1bHQiLCJzZXJ2aWNlcyIsInJvdXRlciIsImRhdGFTb3VyY2VFbmFibGVkIiwiY29tbWVudHNTZXJ2aWNlIiwicG9zdCIsInBhdGgiLCJ2YWxpZGF0ZSIsImJvZHkiLCJzY2hlbWEiLCJhbnkiLCJxdWVyeSIsImNyZWF0ZVZhbGlkYXRlUXVlcnlTY2hlbWEiLCJzZWFyY2hDb21tZW50cyIsInBhcmFtcyIsIm9iamVjdCIsImFsZXJ0SWQiLCJzdHJpbmciLCJjcmVhdGVDb21tZW50IiwicHV0IiwiY29tbWVudElkIiwidXBkYXRlQ29tbWVudCIsImRlbGV0ZSIsImRlbGV0ZUNvbW1lbnQiLCJtb2R1bGUiLCJleHBvcnRzIiwiZGVmYXVsdCJdLCJzb3VyY2VzIjpbImNvbW1lbnRzLmpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXHJcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xyXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxyXG4gKi9cclxuXHJcbmltcG9ydCB7IHNjaGVtYSB9IGZyb20gJ0Bvc2QvY29uZmlnLXNjaGVtYSc7XHJcbmltcG9ydCB7IGNyZWF0ZVZhbGlkYXRlUXVlcnlTY2hlbWEgfSBmcm9tICcuLi9zZXJ2aWNlcy91dGlscy9oZWxwZXJzJztcclxuXHJcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChzZXJ2aWNlcywgcm91dGVyLCBkYXRhU291cmNlRW5hYmxlZCkge1xyXG4gIGNvbnN0IHsgY29tbWVudHNTZXJ2aWNlIH0gPSBzZXJ2aWNlcztcclxuXHJcbiAgcm91dGVyLnBvc3QoXHJcbiAgICB7XHJcbiAgICAgIHBhdGg6ICcvYXBpL2FsZXJ0aW5nL2NvbW1lbnRzL19zZWFyY2gnLFxyXG4gICAgICB2YWxpZGF0ZToge1xyXG4gICAgICAgIGJvZHk6IHNjaGVtYS5hbnkoKSxcclxuICAgICAgICBxdWVyeTogY3JlYXRlVmFsaWRhdGVRdWVyeVNjaGVtYShkYXRhU291cmNlRW5hYmxlZCksXHJcbiAgICAgIH0sXHJcbiAgICB9LFxyXG4gICAgY29tbWVudHNTZXJ2aWNlLnNlYXJjaENvbW1lbnRzXHJcbiAgKTtcclxuXHJcbiAgcm91dGVyLnBvc3QoXHJcbiAgICB7XHJcbiAgICAgIHBhdGg6ICcvYXBpL2FsZXJ0aW5nL2NvbW1lbnRzL3thbGVydElkfScsXHJcbiAgICAgIHZhbGlkYXRlOiB7XHJcbiAgICAgICAgYm9keTogc2NoZW1hLmFueSgpLFxyXG4gICAgICAgIHBhcmFtczogc2NoZW1hLm9iamVjdCh7XHJcbiAgICAgICAgICBhbGVydElkOiBzY2hlbWEuc3RyaW5nKCksXHJcbiAgICAgICAgfSksXHJcbiAgICAgICAgcXVlcnk6IGNyZWF0ZVZhbGlkYXRlUXVlcnlTY2hlbWEoZGF0YVNvdXJjZUVuYWJsZWQpLFxyXG4gICAgICB9LFxyXG4gICAgfSxcclxuICAgIGNvbW1lbnRzU2VydmljZS5jcmVhdGVDb21tZW50XHJcbiAgKTtcclxuXHJcbiAgcm91dGVyLnB1dChcclxuICAgIHtcclxuICAgICAgcGF0aDogJy9hcGkvYWxlcnRpbmcvY29tbWVudHMve2NvbW1lbnRJZH0nLFxyXG4gICAgICB2YWxpZGF0ZToge1xyXG4gICAgICAgIGJvZHk6IHNjaGVtYS5hbnkoKSxcclxuICAgICAgICBwYXJhbXM6IHNjaGVtYS5vYmplY3Qoe1xyXG4gICAgICAgICAgY29tbWVudElkOiBzY2hlbWEuc3RyaW5nKCksXHJcbiAgICAgICAgfSksXHJcbiAgICAgICAgcXVlcnk6IGNyZWF0ZVZhbGlkYXRlUXVlcnlTY2hlbWEoZGF0YVNvdXJjZUVuYWJsZWQpLFxyXG4gICAgICB9LFxyXG4gICAgfSxcclxuICAgIGNvbW1lbnRzU2VydmljZS51cGRhdGVDb21tZW50XHJcbiAgKTtcclxuXHJcbiAgcm91dGVyLmRlbGV0ZShcclxuICAgIHtcclxuICAgICAgcGF0aDogJy9hcGkvYWxlcnRpbmcvY29tbWVudHMve2NvbW1lbnRJZH0nLFxyXG4gICAgICB2YWxpZGF0ZToge1xyXG4gICAgICAgIHBhcmFtczogc2NoZW1hLm9iamVjdCh7XHJcbiAgICAgICAgICBjb21tZW50SWQ6IHNjaGVtYS5zdHJpbmcoKSxcclxuICAgICAgICB9KSxcclxuICAgICAgICBxdWVyeTogY3JlYXRlVmFsaWRhdGVRdWVyeVNjaGVtYShkYXRhU291cmNlRW5hYmxlZCksXHJcbiAgICAgIH0sXHJcbiAgICB9LFxyXG4gICAgY29tbWVudHNTZXJ2aWNlLmRlbGV0ZUNvbW1lbnRcclxuICApO1xyXG59XHJcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBS0EsSUFBQUEsYUFBQSxHQUFBQyxPQUFBO0FBQ0EsSUFBQUMsUUFBQSxHQUFBRCxPQUFBO0FBTkE7QUFDQTtBQUNBO0FBQ0E7O0FBS2UsU0FBQUUsU0FBVUMsUUFBUSxFQUFFQyxNQUFNLEVBQUVDLGlCQUFpQixFQUFFO0VBQzVELE1BQU07SUFBRUM7RUFBZ0IsQ0FBQyxHQUFHSCxRQUFRO0VBRXBDQyxNQUFNLENBQUNHLElBQUksQ0FDVDtJQUNFQyxJQUFJLEVBQUUsZ0NBQWdDO0lBQ3RDQyxRQUFRLEVBQUU7TUFDUkMsSUFBSSxFQUFFQyxvQkFBTSxDQUFDQyxHQUFHLENBQUMsQ0FBQztNQUNsQkMsS0FBSyxFQUFFLElBQUFDLGtDQUF5QixFQUFDVCxpQkFBaUI7SUFDcEQ7RUFDRixDQUFDLEVBQ0RDLGVBQWUsQ0FBQ1MsY0FDbEIsQ0FBQztFQUVEWCxNQUFNLENBQUNHLElBQUksQ0FDVDtJQUNFQyxJQUFJLEVBQUUsa0NBQWtDO0lBQ3hDQyxRQUFRLEVBQUU7TUFDUkMsSUFBSSxFQUFFQyxvQkFBTSxDQUFDQyxHQUFHLENBQUMsQ0FBQztNQUNsQkksTUFBTSxFQUFFTCxvQkFBTSxDQUFDTSxNQUFNLENBQUM7UUFDcEJDLE9BQU8sRUFBRVAsb0JBQU0sQ0FBQ1EsTUFBTSxDQUFDO01BQ3pCLENBQUMsQ0FBQztNQUNGTixLQUFLLEVBQUUsSUFBQUMsa0NBQXlCLEVBQUNULGlCQUFpQjtJQUNwRDtFQUNGLENBQUMsRUFDREMsZUFBZSxDQUFDYyxhQUNsQixDQUFDO0VBRURoQixNQUFNLENBQUNpQixHQUFHLENBQ1I7SUFDRWIsSUFBSSxFQUFFLG9DQUFvQztJQUMxQ0MsUUFBUSxFQUFFO01BQ1JDLElBQUksRUFBRUMsb0JBQU0sQ0FBQ0MsR0FBRyxDQUFDLENBQUM7TUFDbEJJLE1BQU0sRUFBRUwsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO1FBQ3BCSyxTQUFTLEVBQUVYLG9CQUFNLENBQUNRLE1BQU0sQ0FBQztNQUMzQixDQUFDLENBQUM7TUFDRk4sS0FBSyxFQUFFLElBQUFDLGtDQUF5QixFQUFDVCxpQkFBaUI7SUFDcEQ7RUFDRixDQUFDLEVBQ0RDLGVBQWUsQ0FBQ2lCLGFBQ2xCLENBQUM7RUFFRG5CLE1BQU0sQ0FBQ29CLE1BQU0sQ0FDWDtJQUNFaEIsSUFBSSxFQUFFLG9DQUFvQztJQUMxQ0MsUUFBUSxFQUFFO01BQ1JPLE1BQU0sRUFBRUwsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO1FBQ3BCSyxTQUFTLEVBQUVYLG9CQUFNLENBQUNRLE1BQU0sQ0FBQztNQUMzQixDQUFDLENBQUM7TUFDRk4sS0FBSyxFQUFFLElBQUFDLGtDQUF5QixFQUFDVCxpQkFBaUI7SUFDcEQ7RUFDRixDQUFDLEVBQ0RDLGVBQWUsQ0FBQ21CLGFBQ2xCLENBQUM7QUFDSDtBQUFDQyxNQUFBLENBQUFDLE9BQUEsR0FBQUEsT0FBQSxDQUFBQyxPQUFBIn0=