"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    anomalyDetectorService
  } = services;
  router.get({
    path: '/api/alerting/detectors/{detectorId}',
    validate: {
      params: _configSchema.schema.object({
        detectorId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, anomalyDetectorService.getDetector);
  router.post({
    path: '/api/alerting/detectors/_search',
    validate: false
  }, anomalyDetectorService.getDetectors);
  router.get({
    path: '/api/alerting/detectors/{detectorId}/results',
    validate: {
      params: _configSchema.schema.object({
        detectorId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, {
        startTime: _configSchema.schema.maybe(_configSchema.schema.number()),
        endTime: _configSchema.schema.maybe(_configSchema.schema.number()),
        preview: _configSchema.schema.maybe(_configSchema.schema.boolean())
      })
    }
  }, anomalyDetectorService.getDetectorResults);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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