"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    alertService
  } = services;
  const fieldValidations = {
    from: _configSchema.schema.maybe(_configSchema.schema.number()),
    size: _configSchema.schema.number(),
    search: _configSchema.schema.maybe(_configSchema.schema.string()),
    sortField: _configSchema.schema.string(),
    sortDirection: _configSchema.schema.string(),
    severityLevel: _configSchema.schema.maybe(_configSchema.schema.string()),
    alertState: _configSchema.schema.maybe(_configSchema.schema.string()),
    monitorIds: _configSchema.schema.maybe(_configSchema.schema.string()),
    monitorType: _configSchema.schema.maybe(_configSchema.schema.string())
  };
  router.get({
    path: '/api/alerting/alerts',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidations)
    }
  }, alertService.getAlerts);
  const workflowFieldValidations = {
    workflowIds: _configSchema.schema.string(),
    getAssociatedAlerts: _configSchema.schema.boolean(),
    sortString: _configSchema.schema.string(),
    sortOrder: _configSchema.schema.string(),
    startIndex: _configSchema.schema.number(),
    size: _configSchema.schema.number(),
    severityLevel: _configSchema.schema.maybe(_configSchema.schema.string()),
    alertState: _configSchema.schema.maybe(_configSchema.schema.string()),
    searchString: _configSchema.schema.maybe(_configSchema.schema.string()),
    alertIds: _configSchema.schema.string()
  };
  router.get({
    path: '/api/alerting/workflows/alerts',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, workflowFieldValidations)
    }
  }, alertService.getWorkflowAlerts);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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