"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertingPlugin = void 0;
var _operators = require("rxjs/operators");
var _clusters = require("./clusters");
var _services = require("./services");
var _routes = require("../server/routes");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class AlertingPlugin {
  constructor(initializerContext) {
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }
  async setup(core, {
    dataSource
  }) {
    // Get the global configuration settings of the cluster
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    const dataSourceEnabled = !!dataSource;

    // Create clusters
    const alertingESClient = (0, _clusters.createAlertingCluster)(core, globalConfig, dataSourceEnabled, dataSource);
    const adESClient = (0, _clusters.createAlertingADCluster)(core, globalConfig, dataSourceEnabled, dataSource);

    // Initialize services
    const alertService = new _services.AlertService(alertingESClient, dataSourceEnabled);
    const opensearchService = new _services.OpensearchService(alertingESClient, dataSourceEnabled);
    const monitorService = new _services.MonitorService(alertingESClient, dataSourceEnabled);
    const destinationsService = new _services.DestinationsService(alertingESClient, dataSourceEnabled);
    const anomalyDetectorService = new _services.AnomalyDetectorService(adESClient, dataSourceEnabled);
    const findingService = new _services.FindingService(alertingESClient, dataSourceEnabled);
    const crossClusterService = new _services.CrossClusterService(alertingESClient, dataSourceEnabled);
    const commentsService = new _services.CommentsService(alertingESClient, dataSourceEnabled);
    const services = {
      alertService,
      destinationsService,
      opensearchService,
      monitorService,
      anomalyDetectorService,
      findingService,
      crossClusterService,
      commentsService
    };

    // Create router
    const router = core.http.createRouter();
    // Add server routes
    (0, _routes.alerts)(services, router, dataSourceEnabled);
    (0, _routes.destinations)(services, router, dataSourceEnabled);
    (0, _routes.opensearch)(services, router, dataSourceEnabled);
    (0, _routes.monitors)(services, router, dataSourceEnabled);
    (0, _routes.detectors)(services, router, dataSourceEnabled);
    (0, _routes.findings)(services, router, dataSourceEnabled);
    (0, _routes.crossCluster)(services, router, dataSourceEnabled);
    (0, _routes.comments)(services, router, dataSourceEnabled);
    return {};
  }
  async start(core) {
    return {};
  }
}
exports.AlertingPlugin = AlertingPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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