"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = exports.config = void 0;
exports.plugin = plugin;
var _configSchema = require("@osd/config-schema");
var _plugin = require("./plugin");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  })
});
const config = exports.config = {
  exposeToBrowser: {
    // following configs are visible to browser side plugin
    enabled: true
  },
  schema: configSchema
};

// entry point
function plugin(initializerContext) {
  return new _plugin.AlertingPlugin(initializerContext);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9wbHVnaW4iLCJjb25maWdTY2hlbWEiLCJleHBvcnRzIiwic2NoZW1hIiwib2JqZWN0IiwiZW5hYmxlZCIsImJvb2xlYW4iLCJkZWZhdWx0VmFsdWUiLCJjb25maWciLCJleHBvc2VUb0Jyb3dzZXIiLCJwbHVnaW4iLCJpbml0aWFsaXplckNvbnRleHQiLCJBbGVydGluZ1BsdWdpbiJdLCJzb3VyY2VzIjpbImluZGV4LmpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXHJcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xyXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxyXG4gKi9cclxuXHJcbmltcG9ydCB7IHNjaGVtYSB9IGZyb20gJ0Bvc2QvY29uZmlnLXNjaGVtYSc7XHJcbmltcG9ydCB7IEFsZXJ0aW5nUGx1Z2luIH0gZnJvbSAnLi9wbHVnaW4nO1xyXG5cclxuZXhwb3J0IGNvbnN0IGNvbmZpZ1NjaGVtYSA9IHNjaGVtYS5vYmplY3Qoe1xyXG4gIGVuYWJsZWQ6IHNjaGVtYS5ib29sZWFuKHsgZGVmYXVsdFZhbHVlOiB0cnVlIH0pLFxyXG59KTtcclxuXHJcbmV4cG9ydCBjb25zdCBjb25maWcgPSB7XHJcbiAgZXhwb3NlVG9Ccm93c2VyOiB7XHJcbiAgICAvLyBmb2xsb3dpbmcgY29uZmlncyBhcmUgdmlzaWJsZSB0byBicm93c2VyIHNpZGUgcGx1Z2luXHJcbiAgICBlbmFibGVkOiB0cnVlLFxyXG4gIH0sXHJcbiAgc2NoZW1hOiBjb25maWdTY2hlbWEsXHJcbn07XHJcblxyXG4vLyBlbnRyeSBwb2ludFxyXG5leHBvcnQgZnVuY3Rpb24gcGx1Z2luKGluaXRpYWxpemVyQ29udGV4dCkge1xyXG4gIHJldHVybiBuZXcgQWxlcnRpbmdQbHVnaW4oaW5pdGlhbGl6ZXJDb250ZXh0KTtcclxufVxyXG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFLQSxJQUFBQSxhQUFBLEdBQUFDLE9BQUE7QUFDQSxJQUFBQyxPQUFBLEdBQUFELE9BQUE7QUFOQTtBQUNBO0FBQ0E7QUFDQTs7QUFLTyxNQUFNRSxZQUFZLEdBQUFDLE9BQUEsQ0FBQUQsWUFBQSxHQUFHRSxvQkFBTSxDQUFDQyxNQUFNLENBQUM7RUFDeENDLE9BQU8sRUFBRUYsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO0lBQUVDLFlBQVksRUFBRTtFQUFLLENBQUM7QUFDaEQsQ0FBQyxDQUFDO0FBRUssTUFBTUMsTUFBTSxHQUFBTixPQUFBLENBQUFNLE1BQUEsR0FBRztFQUNwQkMsZUFBZSxFQUFFO0lBQ2Y7SUFDQUosT0FBTyxFQUFFO0VBQ1gsQ0FBQztFQUNERixNQUFNLEVBQUVGO0FBQ1YsQ0FBQzs7QUFFRDtBQUNPLFNBQVNTLE1BQU1BLENBQUNDLGtCQUFrQixFQUFFO0VBQ3pDLE9BQU8sSUFBSUMsc0JBQWMsQ0FBQ0Qsa0JBQWtCLENBQUM7QUFDL0MifQ==