"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createAlertingCluster;
var _alertingPlugin = _interopRequireDefault(require("./alertingPlugin"));
var _constants = require("../../services/utils/constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function createAlertingCluster(core, globalConfig, dataSourceEnabled, dataSource) {
  const {
    customHeaders,
    ...rest
  } = globalConfig.opensearch;
  if (dataSourceEnabled) {
    dataSource.registerCustomApiSchema(_alertingPlugin.default);
  }
  return core.opensearch.legacy.createClient(_constants.CLUSTER.ALERTING, {
    plugins: [_alertingPlugin.default],
    // Currently we are overriding any headers with our own since we explicitly required User-Agent to be OpenSearch Dashboards
    // for integration with our backend plugin.
    // TODO: Change our required header to x-<Header> to avoid overriding
    customHeaders: {
      ...customHeaders,
      ..._constants.DEFAULT_HEADERS
    },
    ...rest
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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