"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createAlertingADCluster;
var _adPlugin = _interopRequireDefault(require("./adPlugin"));
var _constants = require("../../services/utils/constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function createAlertingADCluster(core, globalConfig, dataSourceEnabled, dataSource) {
  const {
    customHeaders,
    ...rest
  } = globalConfig.opensearch;
  if (dataSourceEnabled) {
    dataSource.registerCustomApiSchema(_adPlugin.default);
  }
  return core.opensearch.legacy.createClient(_constants.CLUSTER.AD_ALERTING, {
    plugins: [_adPlugin.default],
    // Currently we are overriding any headers with our own since we explicitly required User-Agent to be OpenSearch Dashboards
    // for integration with our backend plugin.
    // TODO: Change our required header to x-<Header> to avoid overriding
    customHeaders: {
      ...customHeaders,
      ..._constants.DEFAULT_HEADERS
    },
    ...rest
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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