"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = alertingPlugin;
var _constants = require("../../services/utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function alertingPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.alerting = components.clientAction.namespaceFactory();
  const alerting = Client.prototype.alerting.prototype;
  alerting.getFindings = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/findings/_search`
    },
    needBody: true,
    method: 'GET'
  });
  alerting.getWorkflow = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/workflows/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.getMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.createMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.createWorkflow = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/workflows?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.deleteMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.deleteWorkflow = ca({
    url: {
      fmt: `${_constants.WORKFLOW_BASE_API}/<%=workflowId%>`,
      req: {
        workflowId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });

  // TODO DRAFT: May need to add 'refresh' assignment here again.
  alerting.updateMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });

  // TODO DRAFT: May need to add 'refresh' assignment here again.
  alerting.updateWorkflow = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/workflows/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.getMonitors = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.acknowledgeAlerts = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>/_acknowledge/alerts`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.acknowledgeChainedAlerts = ca({
    url: {
      fmt: `${_constants.WORKFLOW_BASE_API}/<%=workflowId%>/_acknowledge/alerts`,
      req: {
        workflowId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.getAlerts = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/alerts`
    },
    method: 'GET'
  });
  alerting.executeMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/_execute?dryrun=<%=dryrun%>`,
      req: {
        dryrun: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.getDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}/<%=destinationId%>`,
      req: {
        destinationId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.searchDestinations = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}`
    },
    method: 'GET'
  });
  alerting.createDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}/<%=destinationId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        destinationId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.deleteDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}/<%=destinationId%>`,
      req: {
        destinationId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.getEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/<%=emailAccountId%>`,
      req: {
        emailAccountId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.getEmailAccounts = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.createEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/<%=emailAccountId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        emailAccountId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.deleteEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/<%=emailAccountId%>`,
      req: {
        emailAccountId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.getEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/<%=emailGroupId%>`,
      req: {
        emailGroupId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.getEmailGroups = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.createEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/<%=emailGroupId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        emailGroupId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.deleteEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/<%=emailGroupId%>`,
      req: {
        emailGroupId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.getWorkflowAlerts = ca({
    url: {
      fmt: `${_constants.WORKFLOW_BASE_API}/alerts?workflowIds=<%=workflowIds%>&getAssociatedAlerts=<%=getAssociatedAlerts%>&sortString=<%=sortString%>&sortOrder=<%=sortOrder%>&startIndex=<%=startIndex%>&size=<%=size%>&severityLevel=<%=severityLevel%>&alertState=<%=alertState%>&searchString=<%=searchString%>&alertIds=<%=alertIds%>`,
      req: {
        workflowIds: {
          type: 'string',
          required: true
        },
        alertIds: {
          type: 'string',
          required: true
        },
        getAssociatedAlerts: {
          type: 'boolean',
          required: true
        },
        sortString: {
          type: 'string',
          required: true
        },
        sortOrder: {
          type: 'string',
          required: true
        },
        startIndex: {
          type: 'number',
          required: true
        },
        size: {
          type: 'number',
          required: true
        },
        severityLevel: {
          type: 'string',
          required: false
        },
        alertState: {
          type: 'string',
          required: false
        },
        searchString: {
          type: 'string',
          required: false
        }
      }
    },
    method: 'GET'
  });
  alerting.getRemoteIndexes = ca({
    url: {
      fmt: `${_constants.CROSS_CLUSTER_BASE_API}/indexes?indexes=<%=indexes%>&include_mappings=<%=include_mappings%>`,
      req: {
        indexes: {
          type: 'string',
          required: true
        },
        include_mappings: {
          type: 'boolean',
          required: false
        }
      }
    },
    needBody: true,
    method: 'GET'
  });

  // Comments
  alerting.createComment = ca({
    url: {
      fmt: `${_constants.COMMENTS_BASE_API}/<%=alertId%>`,
      req: {
        alertId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateComment = ca({
    url: {
      fmt: `${_constants.COMMENTS_BASE_API}/<%=commentId%>`,
      req: {
        commentId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.searchComments = ca({
    url: {
      fmt: `${_constants.COMMENTS_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.deleteComment = ca({
    url: {
      fmt: `${_constants.COMMENTS_BASE_API}/<%=commentId%>`,
      req: {
        commentId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'DELETE'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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