"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = alertingADPlugin;
var _constants = require("../../services/utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function alertingADPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.alertingAD = components.clientAction.namespaceFactory();
  const alertingAD = Client.prototype.alertingAD.prototype;
  alertingAD.getDetector = ca({
    url: {
      fmt: `${_constants.AD_BASE_API}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alertingAD.searchDetectors = ca({
    url: {
      fmt: `${_constants.AD_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alertingAD.previewDetector = ca({
    url: {
      fmt: `${_constants.AD_BASE_API}/<%=detectorId%>/_preview`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alertingAD.searchResults = ca({
    url: {
      fmt: `${_constants.AD_BASE_API}/results/_search`
    },
    needBody: true,
    method: 'POST'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uc3RhbnRzIiwicmVxdWlyZSIsImFsZXJ0aW5nQURQbHVnaW4iLCJDbGllbnQiLCJjb25maWciLCJjb21wb25lbnRzIiwiY2EiLCJjbGllbnRBY3Rpb24iLCJmYWN0b3J5IiwicHJvdG90eXBlIiwiYWxlcnRpbmdBRCIsIm5hbWVzcGFjZUZhY3RvcnkiLCJnZXREZXRlY3RvciIsInVybCIsImZtdCIsIkFEX0JBU0VfQVBJIiwicmVxIiwiZGV0ZWN0b3JJZCIsInR5cGUiLCJyZXF1aXJlZCIsIm1ldGhvZCIsInNlYXJjaERldGVjdG9ycyIsIm5lZWRCb2R5IiwicHJldmlld0RldGVjdG9yIiwic2VhcmNoUmVzdWx0cyIsIm1vZHVsZSIsImV4cG9ydHMiLCJkZWZhdWx0Il0sInNvdXJjZXMiOlsiYWRQbHVnaW4uanMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuaW1wb3J0IHsgQURfQkFTRV9BUEkgfSBmcm9tICcuLi8uLi9zZXJ2aWNlcy91dGlscy9jb25zdGFudHMnO1xyXG5cclxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gYWxlcnRpbmdBRFBsdWdpbihDbGllbnQsIGNvbmZpZywgY29tcG9uZW50cykge1xyXG4gIGNvbnN0IGNhID0gY29tcG9uZW50cy5jbGllbnRBY3Rpb24uZmFjdG9yeTtcclxuXHJcbiAgQ2xpZW50LnByb3RvdHlwZS5hbGVydGluZ0FEID0gY29tcG9uZW50cy5jbGllbnRBY3Rpb24ubmFtZXNwYWNlRmFjdG9yeSgpO1xyXG4gIGNvbnN0IGFsZXJ0aW5nQUQgPSBDbGllbnQucHJvdG90eXBlLmFsZXJ0aW5nQUQucHJvdG90eXBlO1xyXG5cclxuICBhbGVydGluZ0FELmdldERldGVjdG9yID0gY2Eoe1xyXG4gICAgdXJsOiB7XHJcbiAgICAgIGZtdDogYCR7QURfQkFTRV9BUEl9LzwlPWRldGVjdG9ySWQlPmAsXHJcbiAgICAgIHJlcToge1xyXG4gICAgICAgIGRldGVjdG9ySWQ6IHtcclxuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxyXG4gICAgICAgICAgcmVxdWlyZWQ6IHRydWUsXHJcbiAgICAgICAgfSxcclxuICAgICAgfSxcclxuICAgIH0sXHJcbiAgICBtZXRob2Q6ICdHRVQnLFxyXG4gIH0pO1xyXG5cclxuICBhbGVydGluZ0FELnNlYXJjaERldGVjdG9ycyA9IGNhKHtcclxuICAgIHVybDoge1xyXG4gICAgICBmbXQ6IGAke0FEX0JBU0VfQVBJfS9fc2VhcmNoYCxcclxuICAgIH0sXHJcbiAgICBuZWVkQm9keTogdHJ1ZSxcclxuICAgIG1ldGhvZDogJ1BPU1QnLFxyXG4gIH0pO1xyXG4gIGFsZXJ0aW5nQUQucHJldmlld0RldGVjdG9yID0gY2Eoe1xyXG4gICAgdXJsOiB7XHJcbiAgICAgIGZtdDogYCR7QURfQkFTRV9BUEl9LzwlPWRldGVjdG9ySWQlPi9fcHJldmlld2AsXHJcbiAgICAgIHJlcToge1xyXG4gICAgICAgIGRldGVjdG9ySWQ6IHtcclxuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxyXG4gICAgICAgICAgcmVxdWlyZWQ6IHRydWUsXHJcbiAgICAgICAgfSxcclxuICAgICAgfSxcclxuICAgIH0sXHJcbiAgICBuZWVkQm9keTogdHJ1ZSxcclxuICAgIG1ldGhvZDogJ1BPU1QnLFxyXG4gIH0pO1xyXG4gIGFsZXJ0aW5nQUQuc2VhcmNoUmVzdWx0cyA9IGNhKHtcclxuICAgIHVybDoge1xyXG4gICAgICBmbXQ6IGAke0FEX0JBU0VfQVBJfS9yZXN1bHRzL19zZWFyY2hgLFxyXG4gICAgfSxcclxuICAgIG5lZWRCb2R5OiB0cnVlLFxyXG4gICAgbWV0aG9kOiAnUE9TVCcsXHJcbiAgfSk7XHJcbn1cclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFLQSxJQUFBQSxVQUFBLEdBQUFDLE9BQUE7QUFMQTtBQUNBO0FBQ0E7QUFDQTs7QUFJZSxTQUFTQyxnQkFBZ0JBLENBQUNDLE1BQU0sRUFBRUMsTUFBTSxFQUFFQyxVQUFVLEVBQUU7RUFDbkUsTUFBTUMsRUFBRSxHQUFHRCxVQUFVLENBQUNFLFlBQVksQ0FBQ0MsT0FBTztFQUUxQ0wsTUFBTSxDQUFDTSxTQUFTLENBQUNDLFVBQVUsR0FBR0wsVUFBVSxDQUFDRSxZQUFZLENBQUNJLGdCQUFnQixDQUFDLENBQUM7RUFDeEUsTUFBTUQsVUFBVSxHQUFHUCxNQUFNLENBQUNNLFNBQVMsQ0FBQ0MsVUFBVSxDQUFDRCxTQUFTO0VBRXhEQyxVQUFVLENBQUNFLFdBQVcsR0FBR04sRUFBRSxDQUFDO0lBQzFCTyxHQUFHLEVBQUU7TUFDSEMsR0FBRyxFQUFHLEdBQUVDLHNCQUFZLGtCQUFpQjtNQUNyQ0MsR0FBRyxFQUFFO1FBQ0hDLFVBQVUsRUFBRTtVQUNWQyxJQUFJLEVBQUUsUUFBUTtVQUNkQyxRQUFRLEVBQUU7UUFDWjtNQUNGO0lBQ0YsQ0FBQztJQUNEQyxNQUFNLEVBQUU7RUFDVixDQUFDLENBQUM7RUFFRlYsVUFBVSxDQUFDVyxlQUFlLEdBQUdmLEVBQUUsQ0FBQztJQUM5Qk8sR0FBRyxFQUFFO01BQ0hDLEdBQUcsRUFBRyxHQUFFQyxzQkFBWTtJQUN0QixDQUFDO0lBQ0RPLFFBQVEsRUFBRSxJQUFJO0lBQ2RGLE1BQU0sRUFBRTtFQUNWLENBQUMsQ0FBQztFQUNGVixVQUFVLENBQUNhLGVBQWUsR0FBR2pCLEVBQUUsQ0FBQztJQUM5Qk8sR0FBRyxFQUFFO01BQ0hDLEdBQUcsRUFBRyxHQUFFQyxzQkFBWSwyQkFBMEI7TUFDOUNDLEdBQUcsRUFBRTtRQUNIQyxVQUFVLEVBQUU7VUFDVkMsSUFBSSxFQUFFLFFBQVE7VUFDZEMsUUFBUSxFQUFFO1FBQ1o7TUFDRjtJQUNGLENBQUM7SUFDREcsUUFBUSxFQUFFLElBQUk7SUFDZEYsTUFBTSxFQUFFO0VBQ1YsQ0FBQyxDQUFDO0VBQ0ZWLFVBQVUsQ0FBQ2MsYUFBYSxHQUFHbEIsRUFBRSxDQUFDO0lBQzVCTyxHQUFHLEVBQUU7TUFDSEMsR0FBRyxFQUFHLEdBQUVDLHNCQUFZO0lBQ3RCLENBQUM7SUFDRE8sUUFBUSxFQUFFLElBQUk7SUFDZEYsTUFBTSxFQUFFO0VBQ1YsQ0FBQyxDQUFDO0FBQ0o7QUFBQ0ssTUFBQSxDQUFBQyxPQUFBLEdBQUFBLE9BQUEsQ0FBQUMsT0FBQSJ9