"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const fs_1 = require("fs");
const _1 = require("./");
describe('Default path finder', () => {
    it('should find a opensearch_dashboards.yml', () => {
        const configPath = (0, _1.getConfigPath)();
        expect(() => (0, fs_1.accessSync)(configPath, fs_1.constants.R_OK)).not.toThrow();
    });
    it('should find a data directory', () => {
        const dataPath = (0, _1.getDataPath)();
        expect(() => (0, fs_1.accessSync)(dataPath, fs_1.constants.R_OK)).not.toThrow();
    });
    it('should find a config directory', () => {
        const configDirectory = (0, _1.getConfigDirectory)();
        expect(() => (0, fs_1.accessSync)(configDirectory, fs_1.constants.R_OK)).not.toThrow();
    });
});
