"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const path_1 = tslib_1.__importDefault(require("path"));
const _1 = require("./");
it('parses package.json', () => {
    expect(_1.opensearchDashboardsPackageJSON.name).toEqual('opensearch-dashboards');
});
it('includes __dirname and __filename', () => {
    const root = path_1.default.resolve(__dirname, '../../../../');
    expect(_1.opensearchDashboardsPackageJSON.__filename).toEqual(path_1.default.resolve(root, 'package.json'));
    expect(_1.opensearchDashboardsPackageJSON.__dirname).toEqual(root);
});
