"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const worker_config_1 = require("./worker_config");
describe('worker_config', () => {
    describe('getWorkerUrl', () => {
        it('should return correct URL format for valid worker IDs', () => {
            expect((0, worker_config_1.getWorkerUrl)('ppl', 12345)).toBe('/12345/editor/workers/ppl.editor.worker.js');
            expect((0, worker_config_1.getWorkerUrl)('json', 12345)).toBe('/12345/editor/workers/json.editor.worker.js');
            expect((0, worker_config_1.getWorkerUrl)('xjson', 12345)).toBe('/12345/editor/workers/xjson.editor.worker.js');
        });
        it('should return undefined for unknown worker IDs', () => {
            expect((0, worker_config_1.getWorkerUrl)('invalid', 12345)).toBeUndefined();
            expect((0, worker_config_1.getWorkerUrl)('', 12345)).toBeUndefined();
        });
    });
    describe('getWorkerUrls', () => {
        it('should return URLs for all three workers with consistent build hash', () => {
            const result = (0, worker_config_1.getWorkerUrls)(12345);
            expect(result).toEqual({
                ppl: '/12345/editor/workers/ppl.editor.worker.js',
                json: '/12345/editor/workers/json.editor.worker.js',
                xjson: '/12345/editor/workers/xjson.editor.worker.js',
            });
        });
    });
});
//# sourceMappingURL=worker_config.test.js.map