"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const formatter_1 = require("./formatter");
describe('formatPPLQuery', () => {
    it('should format single pipe separated query', () => {
        const input = 'source=table1 | fields field1, field2';
        const expected = 'source=table1\n| fields field1, field2';
        expect((0, formatter_1.formatPPLQuery)(input)).toBe(expected);
    });
    it('should format multiple pipe separated query', () => {
        const input = 'source=table1 | fields field1, field2 | where field1 > 10';
        const expected = 'source=table1\n| fields field1, field2\n| where field1 > 10';
        expect((0, formatter_1.formatPPLQuery)(input)).toBe(expected);
    });
    it('should handle extra whitespace', () => {
        const input = 'source=table1    |    fields field1, field2   |   where field1 > 10';
        const expected = 'source=table1\n| fields field1, field2\n| where field1 > 10';
        expect((0, formatter_1.formatPPLQuery)(input)).toBe(expected);
    });
    it('should handle query without pipes', () => {
        const input = 'source=table1';
        const expected = 'source=table1';
        expect((0, formatter_1.formatPPLQuery)(input)).toBe(expected);
    });
});
//# sourceMappingURL=formatter.test.js.map