"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const worker_config_1 = require("./worker_config");
const monaco_environment_1 = require("./monaco_environment");
// Mock Worker constructor
class MockWorker {
    url;
    constructor(url) {
        this.url = url;
    }
    postMessage = jest.fn();
    terminate = jest.fn();
    onmessage = null;
    onerror = null;
}
global.Worker = MockWorker;
describe('monaco_environment', () => {
    describe('setBuildHash and getWorker', () => {
        it('should throw error if getWorker called before setBuildHash', () => {
            expect(() => (0, monaco_environment_1.getWorker)(worker_config_1.WorkerLabels.PPL)).toThrow('Build hash must be set');
        });
        it('should create Worker after setBuildHash is called', () => {
            (0, monaco_environment_1.setBuildHash)(12345);
            const worker = (0, monaco_environment_1.getWorker)(worker_config_1.WorkerLabels.PPL);
            expect(worker).toBeInstanceOf(MockWorker);
            expect(worker.url).toBe('/12345/editor/workers/ppl.editor.worker.js');
        });
        it('should use updated build hash on subsequent calls', () => {
            (0, monaco_environment_1.setBuildHash)(111);
            (0, monaco_environment_1.setBuildHash)(222);
            const worker = (0, monaco_environment_1.getWorker)(worker_config_1.WorkerLabels.PPL);
            expect(worker.url).toBe('/222/editor/workers/ppl.editor.worker.js');
        });
        it('should create new Worker instances on each call', () => {
            (0, monaco_environment_1.setBuildHash)(12345);
            const worker1 = (0, monaco_environment_1.getWorker)(worker_config_1.WorkerLabels.PPL);
            const worker2 = (0, monaco_environment_1.getWorker)(worker_config_1.WorkerLabels.PPL);
            expect(worker1).not.toBe(worker2);
        });
        it('should work with all worker labels', () => {
            (0, monaco_environment_1.setBuildHash)(12345);
            const pplWorker = (0, monaco_environment_1.getWorker)(worker_config_1.WorkerLabels.PPL);
            const jsonWorker = (0, monaco_environment_1.getWorker)(worker_config_1.WorkerLabels.JSON);
            const xjsonWorker = (0, monaco_environment_1.getWorker)(worker_config_1.WorkerLabels.XJSON);
            expect(pplWorker.url).toContain('ppl.editor.worker.js');
            expect(jsonWorker.url).toContain('json.editor.worker.js');
            expect(xjsonWorker.url).toContain('xjson.editor.worker.js');
        });
        it('should throw error for invalid worker label', () => {
            (0, monaco_environment_1.setBuildHash)(12345);
            expect(() => (0, monaco_environment_1.getWorker)('invalid')).toThrow('No worker available');
        });
    });
});
//# sourceMappingURL=monaco_environment.test.js.map