"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const __1 = require("..");
const stream_1 = require("stream");
test('returns value by default', () => {
    const value = new stream_1.Stream();
    expect(__1.schema.stream().validate(value)).toStrictEqual(value);
});
test('Readable is valid', () => {
    const value = new stream_1.Readable();
    expect(__1.schema.stream().validate(value)).toStrictEqual(value);
});
test('Writable is valid', () => {
    const value = new stream_1.Writable();
    expect(__1.schema.stream().validate(value)).toStrictEqual(value);
});
test('Passthrough is valid', () => {
    const value = new stream_1.PassThrough();
    expect(__1.schema.stream().validate(value)).toStrictEqual(value);
});
test('is required by default', () => {
    expect(() => __1.schema.buffer().validate(undefined)).toThrowErrorMatchingInlineSnapshot(`"expected value of type [Buffer] but got [undefined]"`);
});
test('includes namespace in failure', () => {
    expect(() => __1.schema.stream().validate(undefined, {}, 'foo-namespace')).toThrowErrorMatchingInlineSnapshot(`"[foo-namespace]: expected value of type [Stream] but got [undefined]"`);
});
describe('#defaultValue', () => {
    test('returns default when undefined', () => {
        const value = new stream_1.Stream();
        expect(__1.schema.stream({ defaultValue: value }).validate(undefined)).toHaveProperty('_events', {});
        expect(__1.schema.stream({ defaultValue: value }).validate(undefined)).toHaveProperty('_eventsCount', 0);
        expect(__1.schema.stream({ defaultValue: value }).validate(undefined)).toHaveProperty('_maxListeners', undefined);
    });
    test('returns value when specified', () => {
        const value = new stream_1.Stream();
        expect(__1.schema.stream({ defaultValue: new stream_1.PassThrough() }).validate(value)).toStrictEqual(value);
    });
});
test('returns error when not a stream', () => {
    expect(() => __1.schema.stream().validate(123)).toThrowErrorMatchingInlineSnapshot(`"expected value of type [Stream] but got [number]"`);
    expect(() => __1.schema.stream().validate([1, 2, 3])).toThrowErrorMatchingInlineSnapshot(`"expected value of type [Stream] but got [Array]"`);
    expect(() => __1.schema.stream().validate('abc')).toThrowErrorMatchingInlineSnapshot(`"expected value of type [Stream] but got [string]"`);
});
