"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const __1 = require("..");
const { literal } = __1.schema;
test('handles string', () => {
    expect(literal('test').validate('test')).toBe('test');
});
test('handles boolean', () => {
    expect(literal(false).validate(false)).toBe(false);
});
test('handles number', () => {
    expect(literal(123).validate(123)).toBe(123);
});
test('handles null', () => {
    expect(literal(null).validate(null)).toBe(null);
});
test('returns error when not correct', () => {
    expect(() => literal('test').validate('foo')).toThrowErrorMatchingInlineSnapshot(`"expected value to equal [test]"`);
    expect(() => literal(true).validate(false)).toThrowErrorMatchingInlineSnapshot(`"expected value to equal [true]"`);
    expect(() => literal('test').validate([1, 2, 3])).toThrowErrorMatchingInlineSnapshot(`"expected value to equal [test]"`);
    expect(() => literal(123).validate('abc')).toThrowErrorMatchingInlineSnapshot(`"expected value to equal [123]"`);
    expect(() => literal(null).validate(42)).toThrowErrorMatchingInlineSnapshot(`"expected value to equal [null]"`);
});
test('includes namespace in failure', () => {
    expect(() => literal('test').validate('foo', {}, 'foo-namespace')).toThrowErrorMatchingInlineSnapshot(`"[foo-namespace]: expected value to equal [test]"`);
});
