"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const __1 = require("..");
test('works for any value', () => {
    expect(__1.schema.any().validate(true)).toBe(true);
    expect(__1.schema.any().validate(100)).toBe(100);
    expect(__1.schema.any().validate('foo')).toBe('foo');
    expect(__1.schema.any().validate(null)).toBe(null);
    expect(__1.schema.any().validate({ foo: 'bar', baz: 2 })).toEqual({ foo: 'bar', baz: 2 });
});
test('is required by default', () => {
    expect(() => __1.schema.any().validate(undefined)).toThrowErrorMatchingInlineSnapshot(`"expected value of type [any] but got [undefined]"`);
});
test('includes namespace in failure', () => {
    expect(() => __1.schema.any().validate(undefined, {}, 'foo-namespace')).toThrowErrorMatchingInlineSnapshot(`"[foo-namespace]: expected value of type [any] but got [undefined]"`);
});
describe('#defaultValue', () => {
    test('returns default when undefined', () => {
        expect(__1.schema.any({ defaultValue: true }).validate(undefined)).toBe(true);
        expect(__1.schema.any({ defaultValue: 200 }).validate(undefined)).toBe(200);
        expect(__1.schema.any({ defaultValue: 'bar' }).validate(undefined)).toBe('bar');
        expect(__1.schema.any({ defaultValue: { baz: 'foo' } }).validate(undefined)).toEqual({
            baz: 'foo',
        });
    });
    test('returns value when specified', () => {
        expect(__1.schema.any({ defaultValue: true }).validate(false)).toBe(false);
        expect(__1.schema.any({ defaultValue: 200 }).validate(100)).toBe(100);
        expect(__1.schema.any({ defaultValue: 'bar' }).validate('foo')).toBe('foo');
        expect(__1.schema.any({ defaultValue: 'not-null' }).validate(null)).toBe(null);
        expect(__1.schema.any({ defaultValue: { baz: 'foo' } }).validate({ foo: 'bar', baz: 2 })).toEqual({
            foo: 'bar',
            baz: 2,
        });
    });
});
